using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("contract_crude")]
public partial class ContractCrude
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("pipe_loss_allowance")]
    public decimal PipeLossAllowance { get; set; }

    [Column("differential")]
    public decimal Differential { get; set; }

    [Column("is_diff_before_pipe_loss")]
    public bool IsDiffBeforePipeLoss { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractCrudes")]
    public virtual Contract Contract { get; set; } = null!;

    [InverseProperty("ContractCrude")]
    public virtual ICollection<ContractCrudePoint> ContractCrudePoints { get; set; } = new List<ContractCrudePoint>();
}
