using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("business_type")]
[Index("Name", Name = "idx_26138_UK_BusinessType", IsUnique = true)]
public partial class BusinessType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("BusinessType")]
    public virtual ICollection<BusinessSubType> BusinessSubTypes { get; set; } = new List<BusinessSubType>();

    [InverseProperty("BusinessType")]
    public virtual ICollection<Counterparty> Counterparties { get; set; } = new List<Counterparty>();
}
