using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("business_relationship")]
[Index("Name", Name = "uk_business_relationship_name", IsUnique = true)]
public partial class BusinessRelationship
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("BusinessRelationship")]
    public virtual ICollection<CounterpartyRelationship> CounterpartyRelationships { get; set; } = new List<CounterpartyRelationship>();
}
