using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("asp_user_claim")]
[Index("UserId", Name = "ix_asp_user_claim_user_id")]
public partial class AspUserClaim
{
    [Key]
    public int Id { get; set; }

    public int UserId { get; set; }

    [Column(TypeName = "citext")]
    public string? ClaimType { get; set; }

    [Column(TypeName = "citext")]
    public string? ClaimValue { get; set; }

    [ForeignKey("UserId")]
    [InverseProperty("AspUserClaims")]
    public virtual AppUser User { get; set; } = null!;
}
