using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("asp_role_claim")]
[Index("RoleId", Name = "ix_asp_role_claim_role_id")]
public partial class AspRoleClaim
{
    [Key]
    public int Id { get; set; }

    public int RoleId { get; set; }

    [Column(TypeName = "citext")]
    public string? ClaimType { get; set; }

    [Column(TypeName = "citext")]
    public string? ClaimValue { get; set; }

    [ForeignKey("RoleId")]
    [InverseProperty("AspRoleClaims")]
    public virtual AspRole Role { get; set; } = null!;
}
