using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.AspNetCore.Identity;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("app_user")]
[Index("NormalizedEmail", Name = "ix_app_user_email")]
public partial class AppUser : IdentityUser<int>
{
    [Column("is_using_temp_password")]
    public bool IsUsingTempPassword { get; set; }

    [Column("display_name", TypeName = "citext")]
    public string DisplayName { get; set; } = null!;

    [Column("legal_name", TypeName = "citext")]
    public string LegalName { get; set; } = null!;

    [Column("title", TypeName = "citext")]
    public string? Title { get; set; }

    [Column("theme", TypeName = "citext")]
    public string Theme { get; set; } = null!;

    [Column("initials", TypeName = "citext")]
    public string? Initials { get; set; }

    [Column("signature_file_name_on_disk", TypeName = "citext")]
    public string? SignatureFileNameOnDisk { get; set; }

    [InverseProperty("User")]
    public virtual ICollection<AspUserClaim> AspUserClaims { get; set; } = new List<AspUserClaim>();

    [InverseProperty("User")]
    public virtual ICollection<AspUserLogin> AspUserLogins { get; set; } = new List<AspUserLogin>();

    [InverseProperty("User")]
    public virtual ICollection<AspUserToken> AspUserTokens { get; set; } = new List<AspUserToken>();

    [InverseProperty("Trader")]
    public virtual ICollection<BookToTrader> BookToTraders { get; set; } = new List<BookToTrader>();

    [InverseProperty("Signer")]
    public virtual ICollection<Contract> Contracts { get; set; } = new List<Contract>();

    [InverseProperty("SavedByNavigation")]
    public virtual ICollection<CrudeActual> CrudeActuals { get; set; } = new List<CrudeActual>();

    [InverseProperty("CreatedByNavigation")]
    public virtual ICollection<CrudeSupply> CrudeSupplyCreatedByNavigations { get; set; } = new List<CrudeSupply>();

    [InverseProperty("SavedByNavigation")]
    public virtual ICollection<CrudeSupply> CrudeSupplySavedByNavigations { get; set; } = new List<CrudeSupply>();

    [InverseProperty("ConfirmedByNavigation")]
    public virtual ICollection<DealConfirmation> DealConfirmationConfirmedByNavigations { get; set; } = new List<DealConfirmation>();

    [InverseProperty("EmailedByNavigation")]
    public virtual ICollection<DealConfirmation> DealConfirmationEmailedByNavigations { get; set; } = new List<DealConfirmation>();

    [InverseProperty("FaxedByNavigation")]
    public virtual ICollection<DealConfirmation> DealConfirmationFaxedByNavigations { get; set; } = new List<DealConfirmation>();

    [InverseProperty("TicketedByNavigation")]
    public virtual ICollection<DealConfirmation> DealConfirmationTicketedByNavigations { get; set; } = new List<DealConfirmation>();

    [InverseProperty("CreatedByNavigation")]
    public virtual ICollection<Deal> DealCreatedByNavigations { get; set; } = new List<Deal>();

    [InverseProperty("User")]
    public virtual ICollection<DealFilter> DealFilters { get; set; } = new List<DealFilter>();

    [InverseProperty("ModifiedByNavigation")]
    public virtual ICollection<Deal> DealModifiedByNavigations { get; set; } = new List<Deal>();

    [InverseProperty("Trader")]
    public virtual ICollection<Deal> DealTraders { get; set; } = new List<Deal>();

    [InverseProperty("User")]
    public virtual Favorite? Favorite { get; set; }

    [InverseProperty("SavedByNavigation")]
    public virtual ICollection<GasActual> GasActuals { get; set; } = new List<GasActual>();

    [InverseProperty("CreatedByNavigation")]
    public virtual ICollection<GasSupply> GasSupplyCreatedByNavigations { get; set; } = new List<GasSupply>();

    [InverseProperty("SavedByNavigation")]
    public virtual ICollection<GasSupply> GasSupplySavedByNavigations { get; set; } = new List<GasSupply>();

    [InverseProperty("CreatedByNavigation")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeCreatedByNavigations { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("EmailedByNavigation")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeEmailedByNavigations { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("ApprovedByNavigation")]
    public virtual ICollection<InvoiceCrudeLine> InvoiceCrudeLines { get; set; } = new List<InvoiceCrudeLine>();

    [InverseProperty("ModifiedByNavigation")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeModifiedByNavigations { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("CreatedByNavigation")]
    public virtual ICollection<InvoiceGa> InvoiceGaCreatedByNavigations { get; set; } = new List<InvoiceGa>();

    [InverseProperty("EmailedByNavigation")]
    public virtual ICollection<InvoiceGa> InvoiceGaEmailedByNavigations { get; set; } = new List<InvoiceGa>();

    [InverseProperty("ModifiedByNavigation")]
    public virtual ICollection<InvoiceGa> InvoiceGaModifiedByNavigations { get; set; } = new List<InvoiceGa>();

    [InverseProperty("ApprovedByNavigation")]
    public virtual ICollection<InvoiceGasLine> InvoiceGasLines { get; set; } = new List<InvoiceGasLine>();

    [InverseProperty("DataInputer")]
    public virtual ICollection<MarketPrice> MarketPrices { get; set; } = new List<MarketPrice>();

    [InverseProperty("OriginalCreationUser")]
    public virtual ICollection<PipelineContract> PipelineContracts { get; set; } = new List<PipelineContract>();

    [InverseProperty("User")]
    public virtual ICollection<ReportFilter> ReportFilters { get; set; } = new List<ReportFilter>();

    [InverseProperty("User")]
    public virtual ICollection<SecurityUserGroup> SecurityUserGroups { get; set; } = new List<SecurityUserGroup>();

    [InverseProperty("User")]
    public virtual ICollection<SosCrudePipeSetting> SosCrudePipeSettings { get; set; } = new List<SosCrudePipeSetting>();

    [InverseProperty("User")]
    public virtual SosCrudeSetting? SosCrudeSetting { get; set; }

    [InverseProperty("User")]
    public virtual ICollection<SosGasPipeSetting> SosGasPipeSettings { get; set; } = new List<SosGasPipeSetting>();

    [InverseProperty("User")]
    public virtual SosGasSetting? SosGasSetting { get; set; }

    [InverseProperty("User")]
    public virtual ICollection<UserScreenSort> UserScreenSorts { get; set; } = new List<UserScreenSort>();

    [ForeignKey("UserId")]
    [InverseProperty("Users")]
    public virtual ICollection<AspRole> Roles { get; set; } = new List<AspRole>();
}
