using Fast.Web;
using Fast.Models;
using Microsoft.OData.Edm;
using Microsoft.OData.ModelBuilder;

Main.CustomEdmModel = Helper.GetCustomEdmModel();
Main.DirectoriesToCreate = Helper.GetDirectoriesToCreate();
Main.Configure(args, Type.GetType("Fast.Web.Logic.JobsHelper"));
await Main.RunAsync();

namespace Fast.Web
{
    public static class Helper
    {
        public static string[] GetDirectoriesToCreate()
        {
            return new string[] {
                "DealTemplates",
                "DealConfirms",
                "DealTickets",
                "Signatures",
                "Logos",
                "PaymentInstructions",
                "ContractTemplates",
                "ContractDocs"
            };
        }

        public static IEdmModel GetCustomEdmModel()
        {
            var builder = new ODataConventionModelBuilder();

            builder.Function("GetDealItems").Returns<DealListItem>();
            builder.Function("GetContactItems").Returns<ContactListItem>();
            builder.Function("GetPaymentInstructionsItems").Returns<PaymentInstructionsListItem>();
            builder.Function("GetMainContractItems").Returns<MainContractListItem>();

            return builder.GetEdmModel();
        }
    }
}
