﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Models
{
    public class MainContractListItem
    {
        [Key] //need to set primary key for OData
        public int MainContractId { get; set; }

        [Display(Name = "Contract #")] public string? ContractNum { get; set; } = "";
        [Display(Name = "Contract Name")] public string? ContractName { get; set; } = "";
        [Display(Name = "Their Contract #")] public string? TheirContractNum { get; set; } = "";
        [Display(Name = "Internal Entity")] public string InternalEntity { get; set; } = "";
        [Display(Name = "Counterparty")] public string Counterparty { get; set; } = "";
        [Display(Name = "Product")] public string Product { get; set; } = "";
        [Display(Name = "Status")] public string Status { get; set; } = "";
        [Display(Name = "Effective Date")] public DateTime? EffectiveDate { get; set; }
        [Display(Name = "Execution Date")] public DateTime? ExecutionDate { get; set; }
        [Display(Name = "Last Amendment")] public DateOnly? LastAmendmentDate { get; set; }
        [Display(Name = "Termination")] public string Termination { get; set; } = "";
    }
}
