﻿namespace Fast.Models;

public class MainContractExhibitBInfo
{
    public MainContractExhibitBDetail? ExhibitBDetail { get; set; }
    public MainContractExhibitBSelectionDetail? ExhibitBSelectionDetail { get; set; }
    public List<MainContractExhibitBItem> ExhibitBItemsToDelete { get; set; } = new();
}

public class MainContractExhibitBDetail
{
    public string Title { get; set; } = "";
    public string Body { get; set; } = "";
    public bool ShowInactive { get; set; } = false;
    public List<MainContractExhibitBItem> Items { get; set; } = new();
    public DateOnly? ExhibitBAmendmentDate { get; set; }
}

public class MainContractExhibitBItem
{
    public int Id { get; set; }
    public string Title { get; set; } = "";
    public string? Body { get; set; }
    public int Ordinal { get; set; }
    public bool IsContractSpecific { get; set; }
    public DateOnly? InactiveDate { get; set; }
    public List<MainContractExhibitBItem> Items { get; set; } = new();
    public int? ParentId { get; set; }

}

public class MainContractExhibitBSelectionDetail
{
    public int ContractId { get; set; }
    public List<int> ExibhitBSelectedIds { get; set; } = new();
}
