﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Models
{
    public class DealListItem
    {
        [Key] //need to set primary key for OData
        public int Id { get; set; }

        [Display(Name = "Deal #", Description = "150")] public string DealNum { get; set; } = "";
        public string TicketNum { get; set; } = "";
        public int? TicketNumber { get; set; }
        public string TicketPrefix { get; set; } = "";
        [Display(Name = "Accounting Month", Description = "150,1,date,MMM yyyy")] public DateOnly? AccountingMonth { get; set; }
        [Display(Name = "Basis", Description = "150,1,numeric,{0:c5}")] public double? Basis { get; set; }
        [Display(Name = "Book", Description = "150,1")] public string Book { get; set; } = "";
        public int? BookId { get; set; }
        [Display(Name = "Broker", Description = "150,1")] public string Broker { get; set; } = "";
        public int? BrokerId { get; set; }
        [Display(Name = "Broker Account", Description = "150,1")] public string BrokerAccount { get; set; } = "";
        public int? BrokerAccountId { get; set; }
        [Display(Name = "Buy/Sell", Description = "75,1")] public string BuySell { get; set; } = "";
        public int? BuyButton { get; set; }
        [Display(Name = "Contact", Description = "150,1")] public string Contact { get; set; } = "";
        [Display(Name = "Contracts", Description = "100,1,numeric,{0:n0}")] public int? Contracts { get; set; }
        [Display(Name = "Counterparty", Description = "200,1")] public string Counterparty { get; set; } = "";
        public int? CounterpartyId { get; set; }
        [Display(Name = "Deal Purpose", Description = "140,1")] public string DealPurpose { get; set; } = "";
        public int? DealPurposeId { get; set; }
        [Display(Name = "Deal Status", Description = "130,1")] public string DealStatus { get; set; } = "";
        public int DealStatusId { get; set; }
        [Display(Name = "Deal Type", Description = "130,1")] public string DealType { get; set; } = "";
        public int? DealTypeId { get; set; }
        [Display(Name = "End Date", Description = "125,1,date,{0:d}")] public DateOnly? EndDate { get; set; }
        [Display(Name = "Fixed Price", Description = "150,1,numeric,{0:c5}")] public double? FixedPrice { get; set; }
        [Display(Name = "Force Majeure?", Description = "70,1")] public string ForceMajeure { get; set; } = "";
        [Display(Name = "Hypothetical?", Description = "120,1")] public string Hypothetical { get; set; } = "";
        public int HypotheticalId { get; set; }
        [Display(Name = "Internal Entity", Description = "200,1")] public string InternalEntity { get; set; } = "";
        public int? InternalEntityId { get; set; }
        [Display(Name = "Pipeline", Description = "200,1")] public string Pipeline { get; set; } = "";
        public int? PipelineId { get; set; }
        [Display(Name = "Pipeline Source/Delivery", Description = "200,1")] public string PipelineSourceDelivery { get; set; } = "";
        public int? PipelineSourceDeliveryId { get; set; }
        [Display(Name = "Point", Description = "200,1")] public string Point { get; set; } = "";
        public int? PointId { get; set; }
        [Display(Name = "Point Source/Delivery", Description = "200,1")] public string PointSourceDelivery { get; set; } = "";
        [Display(Name = "Portfolio", Description = "150,1")] public string Portfolio { get; set; } = "";
        public int? PortfolioId { get; set; }
        [Display(Name = "Prem/Disc", Description = "150,1,numeric,{0:c5}")] public double? PremDisc { get; set; }
        [Display(Name = "Price Index", Description = "200,1")] public string PriceIndex { get; set; } = "";
        public int? PriceIndexId { get; set; }
        [Display(Name = "Product", Description = "150,1")] public string Product { get; set; } = "";
        public int ProductId { get; set; }
        [Display(Name = "Region", Description = "150,1")] public string Region { get; set; } = "";
        public int? RegionId { get; set; }
        [Display(Name = "Start Date", Description = "125,1,date,{0:d}")] public DateOnly? StartDate { get; set; }
        [Display(Name = "Strategy", Description = "150,1")] public string Strategy { get; set; } = "";
        public int? StrategyId { get; set; }
        [Display(Name = "Trader", Description = "150,1")] public string Trader { get; set; } = "";
        public int? TraderId { get; set; }
        [Display(Name = "Trade Date", Description = "125,1,date,{0:d}")] public DateOnly? TradeDate { get; set; }
        [Display(Name = "Transaction Type", Description = "150,1")] public string TransactionType { get; set; } = "";
        public int? TransactionTypeId { get; set; }
        [Display(Name = "Variable Volume?", Description = "70,1")] public string VariableVolume { get; set; } = "";
        [Display(Name = "Volume", Description = "150,1,numeric,{0:n0}")] public double? Volume { get; set; }
        [Display(Name = "Send Email?", Description = "125,1")] public string SendEmail { get; set; } = "";
        [Display(Name = "Email Address", Description = "250,1")] public string EmailAddress { get; set; } = "";
        [Display(Name = "Emailed Date", Description = "125,1,date,{0:d}")] public DateTime? EmailDate { get; set; }
        [Display(Name = "Emailed By", Description = "150,1")] public string EmailedBy { get; set; } = "";
        [Display(Name = "Send Fax?", Description = "120,1")] public string SendFax { get; set; } = "";
        [Display(Name = "Fax #", Description = "150,1")] public string FaxNumber { get; set; } = "";
        [Display(Name = "Faxed Date", Description = "125,1,date,{0:d}")] public DateTime? FaxDate { get; set; }
        [Display(Name = "Faxed By", Description = "150,1")] public string FaxedBy { get; set; } = "";
        public DateTime Created { get; set; }
        public DateTime? Modified { get; set; }
        public DateTime? Distributed { get; set; }
    }
}
