﻿namespace Fast.Logic.GasControl
{
    internal class TransferSetter
    {
        private readonly int TransferNum;
        private readonly GasTrackExportItem ExportItem;

        public TransferSetter(GasTrackExportItem ExportItem, int TransferNum)
        {
            this.TransferNum = TransferNum;
            this.ExportItem = ExportItem;
        }

        public string TSF { get; set; } = "";
        public string TSF_OUT_POINT { get; set; } = "";
        public string TSF_IN_PIPE { get; set; } = "";
        public string TSF_IN_POINT { get; set; } = "";
        public string TSF_FUEL_RATE { get; set; } = "";
        public string TSF_IN_CONTRACT { get; set; } = "";
        public string TSF_TRANS_RATE { get; set; } = "";
        public string TSF_OWNERSHIP { get; set; } = "";

        public void SetItemValues()
        {
            switch (TransferNum)
            {
                case 1:
                    {
                        ExportItem.TSF1 = TSF;
                        ExportItem.TSF1_OUT_POINT = TSF_OUT_POINT;
                        ExportItem.TSF1_IN_PIPE = TSF_IN_PIPE;
                        ExportItem.TSF1_IN_POINT = TSF_IN_POINT;
                        ExportItem.TSF1_FUEL_RATE = TSF_FUEL_RATE;
                        ExportItem.TSF1_IN_CONTRACT = TSF_IN_CONTRACT;
                        ExportItem.TSF1_TRANS_RATE = TSF_TRANS_RATE;
                        ExportItem.TSF1_OWNERSHIP = TSF_OWNERSHIP;
                        break;
                    }

                case 2:
                    {
                        ExportItem.TSF2 = TSF;
                        ExportItem.TSF2_OUT_POINT = TSF_OUT_POINT;
                        ExportItem.TSF2_IN_PIPE = TSF_IN_PIPE;
                        ExportItem.TSF2_IN_POINT = TSF_IN_POINT;
                        ExportItem.TSF2_FUEL_RATE = TSF_FUEL_RATE;
                        ExportItem.TSF2_IN_CONTRACT = TSF_IN_CONTRACT;
                        ExportItem.TSF2_TRANS_RATE = TSF_TRANS_RATE;
                        ExportItem.TSF2_OWNERSHIP = TSF_OWNERSHIP;
                        break;
                    }

                case 3:
                    {
                        ExportItem.TSF3 = TSF;
                        ExportItem.TSF3_OUT_POINT = TSF_OUT_POINT;
                        ExportItem.TSF3_IN_PIPE = TSF_IN_PIPE;
                        ExportItem.TSF3_IN_POINT = TSF_IN_POINT;
                        ExportItem.TSF3_FUEL_RATE = TSF_FUEL_RATE;
                        ExportItem.TSF3_IN_CONTRACT = TSF_IN_CONTRACT;
                        ExportItem.TSF3_TRANS_RATE = TSF_TRANS_RATE;
                        ExportItem.TSF3_OWNERSHIP = TSF_OWNERSHIP;
                        break;
                    }

                case 4:
                    {
                        ExportItem.TSF4 = TSF;
                        ExportItem.TSF4_OUT_POINT = TSF_OUT_POINT;
                        ExportItem.TSF4_IN_PIPE = TSF_IN_PIPE;
                        ExportItem.TSF4_IN_POINT = TSF_IN_POINT;
                        ExportItem.TSF4_FUEL_RATE = TSF_FUEL_RATE;
                        ExportItem.TSF4_IN_CONTRACT = TSF_IN_CONTRACT;
                        ExportItem.TSF4_TRANS_RATE = TSF_TRANS_RATE;
                        ExportItem.TSF4_OWNERSHIP = TSF_OWNERSHIP;
                        break;
                    }

                case 5:
                    {
                        ExportItem.TSF5 = TSF;
                        ExportItem.TSF5_OUT_POINT = TSF_OUT_POINT;
                        ExportItem.TSF5_IN_PIPE = TSF_IN_PIPE;
                        ExportItem.TSF5_IN_POINT = TSF_IN_POINT;
                        ExportItem.TSF5_FUEL_RATE = TSF_FUEL_RATE;
                        ExportItem.TSF5_IN_CONTRACT = TSF_IN_CONTRACT;
                        ExportItem.TSF5_TRANS_RATE = TSF_TRANS_RATE;
                        ExportItem.TSF5_OWNERSHIP = TSF_OWNERSHIP;
                        break;
                    }

                default:
                    {
                        throw new NotImplementedException("more than 5 transfer deals has not been implemented");
                    }
            }
        }
    }
}
