﻿using System.Data;
using static Fast.Shared.Models.Enums;

namespace Fast.Logic.GasControl
{
    internal class GasTrackHelper
    {
        public static List<GasTrackExportItem> GroupExportList(List<GasTrackExportItem> GasExport)
        {
            var groupedItems = (
                from gei in GasExport
                group gei by new
                {
                    gei.bBOT_DEAL,
                    gei.bVENDOR,
                    gei.bTYPE,
                    gei.bPIPELINE,
                    gei.bPOINT,
                    gei.bCONTRACT,
                    gei.bTRADER,
                    gei.bTRADE_DATE,
                    gei.bSTART_DATE,
                    gei.bEND_DATE,
                    gei.bINV_PRICE,
                    gei.bPRICE_TYPE,
                    gei.bPREMDISC,
                    gei.bPRICE,
                    gei.bINDEX,
                    gei.bINT_ENTITY,
                    gei.bTRANS_RATE,
                    gei.bFUEL_RATE,
                    gei.bOWNERSHIP,
                    gei.TSF1,
                    gei.TSF1_OUT_POINT,
                    gei.TSF1_IN_PIPE,
                    gei.TSF1_IN_POINT,
                    gei.TSF1_IN_CONTRACT,
                    gei.TSF1_TRANS_RATE,
                    gei.TSF1_FUEL_RATE,
                    gei.TSF1_OWNERSHIP,
                    gei.TSF2,
                    gei.TSF2_OUT_POINT,
                    gei.TSF2_IN_PIPE,
                    gei.TSF2_IN_POINT,
                    gei.TSF2_IN_CONTRACT,
                    gei.TSF2_TRANS_RATE,
                    gei.TSF2_FUEL_RATE,
                    gei.TSF2_OWNERSHIP,
                    gei.TSF3,
                    gei.TSF3_OUT_POINT,
                    gei.TSF3_IN_PIPE,
                    gei.TSF3_IN_POINT,
                    gei.TSF3_IN_CONTRACT,
                    gei.TSF3_TRANS_RATE,
                    gei.TSF3_FUEL_RATE,
                    gei.TSF3_OWNERSHIP,
                    gei.TSF4,
                    gei.TSF4_OUT_POINT,
                    gei.TSF4_IN_PIPE,
                    gei.TSF4_IN_POINT,
                    gei.TSF4_IN_CONTRACT,
                    gei.TSF4_TRANS_RATE,
                    gei.TSF4_FUEL_RATE,
                    gei.TSF4_OWNERSHIP,
                    gei.TSF5,
                    gei.TSF5_OUT_POINT,
                    gei.TSF5_IN_PIPE,
                    gei.TSF5_IN_POINT,
                    gei.TSF5_IN_CONTRACT,
                    gei.TSF5_TRANS_RATE,
                    gei.TSF5_FUEL_RATE,
                    gei.TSF5_OWNERSHIP,
                    gei.sSELL_DEAL,
                    gei.sGASTRACK,
                    gei.sCUSTOMER,
                    gei.sTYPE,
                    gei.sPIPELINE,
                    gei.sPOINT,
                    gei.sCONTRACT,
                    gei.sTRADER,
                    gei.sTRADE_DATE,
                    gei.sSTART_DATE,
                    gei.sEND_DATE,
                    gei.sINV_PRICE,
                    gei.sPRICE_TYPE,
                    gei.sPREMDISC,
                    gei.sPRICE,
                    gei.sINDEX,
                    gei.sINT_ENTITY
                } into g
                select new GasTrackExportItem
                {
                    bBOT_DEAL = g.Key.bBOT_DEAL,
                    bVENDOR = g.Key.bVENDOR,
                    bTYPE = g.Key.bTYPE,
                    bPIPELINE = g.Key.bPIPELINE,
                    bPOINT = g.Key.bPOINT,
                    bCONTRACT = g.Key.bCONTRACT,
                    bTRADER = g.Key.bTRADER,
                    bTRADE_DATE = g.Key.bTRADE_DATE,
                    bSTART_DATE = g.Key.bSTART_DATE,
                    bEND_DATE = g.Key.bEND_DATE,
                    bVOLUME = g.Sum(x => int.Parse(x.bVOLUME ?? "0")).ToString(),
                    bINV_PRICE = g.Key.bINV_PRICE,
                    bPRICE_TYPE = g.Key.bPRICE_TYPE,
                    bPREMDISC = g.Key.bPREMDISC,
                    bPRICE = g.Key.bPRICE,
                    bINDEX = g.Key.bINDEX,
                    bINT_ENTITY = g.Key.bINT_ENTITY,
                    bTRANS_RATE = g.Key.bTRANS_RATE,
                    bFUEL_RATE = g.Key.bFUEL_RATE,
                    bOWNERSHIP = g.Key.bOWNERSHIP,
                    TSF1 = g.Key.TSF1,
                    TSF1_OUT_POINT = g.Key.TSF1_OUT_POINT,
                    TSF1_IN_PIPE = g.Key.TSF1_IN_PIPE,
                    TSF1_IN_POINT = g.Key.TSF1_IN_POINT,
                    TSF1_IN_CONTRACT = g.Key.TSF1_IN_CONTRACT,
                    TSF1_TRANS_RATE = g.Key.TSF1_TRANS_RATE,
                    TSF1_FUEL_RATE = g.Key.TSF1_FUEL_RATE,
                    TSF1_OWNERSHIP = g.Key.TSF1_OWNERSHIP,
                    TSF2 = g.Key.TSF2,
                    TSF2_OUT_POINT = g.Key.TSF2_OUT_POINT,
                    TSF2_IN_PIPE = g.Key.TSF2_IN_PIPE,
                    TSF2_IN_POINT = g.Key.TSF2_IN_POINT,
                    TSF2_IN_CONTRACT = g.Key.TSF2_IN_CONTRACT,
                    TSF2_TRANS_RATE = g.Key.TSF2_TRANS_RATE,
                    TSF2_FUEL_RATE = g.Key.TSF2_FUEL_RATE,
                    TSF2_OWNERSHIP = g.Key.TSF2_OWNERSHIP,
                    TSF3 = g.Key.TSF3,
                    TSF3_OUT_POINT = g.Key.TSF3_OUT_POINT,
                    TSF3_IN_PIPE = g.Key.TSF3_IN_PIPE,
                    TSF3_IN_POINT = g.Key.TSF3_IN_POINT,
                    TSF3_IN_CONTRACT = g.Key.TSF3_IN_CONTRACT,
                    TSF3_TRANS_RATE = g.Key.TSF3_TRANS_RATE,
                    TSF3_FUEL_RATE = g.Key.TSF3_FUEL_RATE,
                    TSF3_OWNERSHIP = g.Key.TSF3_OWNERSHIP,
                    TSF4 = g.Key.TSF4,
                    TSF4_OUT_POINT = g.Key.TSF4_OUT_POINT,
                    TSF4_IN_PIPE = g.Key.TSF4_IN_PIPE,
                    TSF4_IN_POINT = g.Key.TSF4_IN_POINT,
                    TSF4_IN_CONTRACT = g.Key.TSF4_IN_CONTRACT,
                    TSF4_TRANS_RATE = g.Key.TSF4_TRANS_RATE,
                    TSF4_FUEL_RATE = g.Key.TSF4_FUEL_RATE,
                    TSF4_OWNERSHIP = g.Key.TSF4_OWNERSHIP,
                    TSF5 = g.Key.TSF5,
                    TSF5_OUT_POINT = g.Key.TSF5_OUT_POINT,
                    TSF5_IN_PIPE = g.Key.TSF5_IN_PIPE,
                    TSF5_IN_POINT = g.Key.TSF5_IN_POINT,
                    TSF5_IN_CONTRACT = g.Key.TSF5_IN_CONTRACT,
                    TSF5_TRANS_RATE = g.Key.TSF5_TRANS_RATE,
                    TSF5_FUEL_RATE = g.Key.TSF5_FUEL_RATE,
                    TSF5_OWNERSHIP = g.Key.TSF5_OWNERSHIP,
                    sSELL_DEAL = g.Key.sSELL_DEAL,
                    sGASTRACK = g.Key.sGASTRACK,
                    sCUSTOMER = g.Key.sCUSTOMER,
                    sTYPE = g.Key.sTYPE,
                    sPIPELINE = g.Key.sPIPELINE,
                    sPOINT = g.Key.sPOINT,
                    sCONTRACT = g.Key.sCONTRACT,
                    sTRADER = g.Key.sTRADER,
                    sTRADE_DATE = g.Key.sTRADE_DATE,
                    sSTART_DATE = g.Key.sSTART_DATE,
                    sEND_DATE = g.Key.sEND_DATE,
                    sVOLUME = g.Sum(x => int.Parse(x.sVOLUME ?? "0")).ToString(),
                    sINV_PRICE = g.Key.sINV_PRICE,
                    sPRICE_TYPE = g.Key.sPRICE_TYPE,
                    sPREMDISC = g.Key.sPREMDISC,
                    sPRICE = g.Key.sPRICE,
                    sINDEX = g.Key.sINDEX,
                    sINT_ENTITY = g.Key.sINT_ENTITY
                }
            ).ToList();

            return groupedItems;
        }

        public static MemoryStream CreateGasTrackFile(DataTable DT, Dictionary<string, GasTrackFieldAttribute> GasTrackFieldLengths, bool PrintFieldNames = false, string Separator = "|")
        {
            //using MemoryStream memStream = new();
            MemoryStream memStream = new();
            StreamWriter sw = new(memStream);
            if (PrintFieldNames)
            {
                var OPString = string.Empty;
                for (var ColCt = 0; ColCt <= DT.Columns.Count - 1; ColCt++)
                {
                    if (!string.IsNullOrEmpty(OPString))
                        OPString += Separator;
                    string ValueStr = DT.Columns[ColCt].Caption;

                    GasTrackFieldAttribute GasTrackAttribute = GasTrackFieldLengths[DT.Columns[ColCt].Caption];
                    int Length = GasTrackAttribute.FieldLength;

                    if (GasTrackAttribute.FieldType == FieldType.Alpha)
                        OPString += Util.String.FixLength(ValueStr, Length, PadDirection.Right);
                    else if (GasTrackAttribute.FieldType == FieldType.Numeric)
                        OPString += Util.String.FixLength(ValueStr, Length, PadDirection.Left);
                }
                sw.WriteLine(OPString);
            }

            foreach (DataRow DR in DT.Rows)
            {
                var OPString = string.Empty;
                for (var ColCt = 0; ColCt <= DT.Columns.Count - 1; ColCt++)
                {
                    if (!string.IsNullOrEmpty(OPString))
                        OPString += Separator;
                    string ValueStr = DR[ColCt]?.ToString() ?? "";

                    GasTrackFieldAttribute GasTrackAttribute = GasTrackFieldLengths[DT.Columns[ColCt].Caption];
                    int Length = GasTrackAttribute.FieldLength;

                    if (GasTrackAttribute.FieldType == FieldType.Alpha)
                        OPString += Util.String.FixLength(ValueStr, Length, PadDirection.Right);
                    else if (GasTrackAttribute.FieldType == FieldType.Numeric)
                        OPString += Util.String.FixLength(ValueStr, Length, PadDirection.Left);
                }
                sw.WriteLine(OPString);
            }
            
            sw.Flush();
            memStream.Seek(0, SeekOrigin.Begin);
            return memStream;
        }
    }
}
