namespace Fast.Logic;
public class ContractHelper
{
    public const string dateLongFormat = "MMMM dd, yyyy";

    public static string GetCityStateZipStr(string city, string state, string zip)
    {
        var comma = string.IsNullOrWhiteSpace(city) ? "" : ", ";
        zip = string.IsNullOrWhiteSpace(zip) ? "" : " " + zip;
        var cityStateZip = $"{city}{comma}{state}{zip}";
        return cityStateZip;
    }

    public static HashSet<string> GetDocKeys()
    {
        HashSet<string> keys = new(StringComparer.OrdinalIgnoreCase)
        {
            "InsertedText",
            "EffectiveDateLong",
            "EffectiveDateShort",
            "ExecutionDateLong",
            "ExecutionDateShort",
            "LastAmendmentDateLong",
            "LastAmendmentDateShort",
            "ContractSignerName",
            "ContractSignerTitle",

            "A-Name",
            "A-Address1",
            "A-Address2",
            "A-CityStateZip",
            "A-BusinessWebsite",
            "A-ContractNumberA",
            "A-DUNSNumber",
            "A-FederalTaxID",
            "A-FederalTaxIDNumber",
            "A-OtherTaxID",
            "A-OtherTaxIDNumber",
            "A-Jurisdiction",
            "A-CompanyTypeCorporation",
            "A-CompanyTypeLLC",
            "A-CompanyTypeLP",
            "A-CompanyTypePartnership",
            "A-CompanyTypeLLP",
            "A-CompanyTypeOther",
            "A-CompanyTypeOtherInfo",
            "A-Guarantor",
            "A-Commercial_Address1",
            "A-Commercial_Address2",
            "A-Commercial_CityStateZip",
            "A-Commercial_Attn",
            "A-Commercial_Telephone",
            "A-Commercial_Fax",
            "A-Commercial_Email",
            "A-ContractNumberA",
            "A-Scheduling_Address1",
            "A-Scheduling_Address2",
            "A-Scheduling_CityStateZip",
            "A-Scheduling_Attn",
            "A-Scheduling_Telephone",
            "A-Scheduling_Fax",
            "A-Scheduling_Email",
            "A-Notices_Address1",
            "A-Notices_Address2",
            "A-Notices_CityStateZip",
            "A-Notices_Attn",
            "A-Notices_Telephone",
            "A-Notices_Fax",
            "A-Notices_Email",
            "A-Credit_Address1",
            "A-Credit_Address2",
            "A-Credit_CityStateZip",
            "A-Credit_Attn",
            "A-Credit_Telephone",
            "A-Credit_Fax",
            "A-Credit_Email",
            "A-Confirmations_Address1",
            "A-Confirmations_Address2",
            "A-Confirmations_CityStateZip",
            "A-Confirmations_Attn",
            "A-Confirmations_Telephone",
            "A-Confirmations_Fax",
            "A-Confirmations_Email",
            "A-Invoices_Address1",
            "A-Invoices_Address2",
            "A-Invoices_CityStateZip",
            "A-Invoices_Attn",
            "A-Invoices_Telephone",
            "A-Invoices_Fax",
            "A-Invoices_Email",
            "A-WireTransfer_Bank",
            "A-WireTransfer_ABA",
            "A-WireTransfer_Acct",
            "A-WireTransfer_OtherDetails",
            "A-ACH_Bank",
            "A-ACH_ABA",
            "A-ACH_Acct",
            "A-ACH_OtherDetails",
            "A-Checks_Attn",
            "A-Checks_Address1",
            "A-Checks_Address2",
            "A-Checks_CityStateZip",

            "B-Name",
            "B-Address1",
            "B-Address2",
            "B-CityStateZip",
            "B-BusinessWebsite",
            "B-ContractNumberB",
            "B-DUNSNumber",
            "B-FederalTaxID",
            "B-FederalTaxIDNumber",
            "B-OtherTaxID",
            "B-OtherTaxIDNumber",
            "B-Jurisdiction",
            "B-CompanyTypeCorporation",
            "B-CompanyTypeLLC",
            "B-CompanyTypeLP",
            "B-CompanyTypePartnership",
            "B-CompanyTypeLLP",
            "B-CompanyTypeOther",
            "B-CompanyTypeOtherInfo",
            "B-Guarantor",
            "B-Commercial_Address1",
            "B-Commercial_Address2",
            "B-Commercial_CityStateZip",
            "B-Commercial_Attn",
            "B-Commercial_Telephone",
            "B-Commercial_Fax",
            "B-Commercial_Email",
            "B-Scheduling_Address1",
            "B-Scheduling_Address2",
            "B-Scheduling_CityStateZip",
            "B-Scheduling_Attn",
            "B-Scheduling_Telephone",
            "B-Scheduling_Fax",
            "B-Scheduling_Email",
            "B-Notices_Address1",
            "B-Notices_Address2",
            "B-Notices_CityStateZip",
            "B-Notices_Attn",
            "B-Notices_Telephone",
            "B-Notices_Fax",
            "B-Notices_Email",
            "B-Credit_Address1",
            "B-Credit_Address2",
            "B-Credit_CityStateZip",
            "B-Credit_Attn",
            "B-Credit_Telephone",
            "B-Credit_Fax",
            "B-Credit_Email",
            "B-Confirmations_Address1",
            "B-Confirmations_Address2",
            "B-Confirmations_CityStateZip",
            "B-Confirmations_Attn",
            "B-Confirmations_Telephone",
            "B-Confirmations_Fax",
            "B-Confirmations_Email",
            "B-Invoices_Address1",
            "B-Invoices_Address2",
            "B-Invoices_CityStateZip",
            "B-Invoices_Attn",
            "B-Invoices_Telephone",
            "B-Invoices_Fax",
            "B-Invoices_Email",
            "B-WireTransfer_Bank",
            "B-WireTransfer_ABA",
            "B-WireTransfer_Acct",
            "B-WireTransfer_OtherDetails",
            "B-ACH_Bank",
            "B-ACH_ABA",
            "B-ACH_Acct",
            "B-ACH_OtherDetails",
            "B-Checks_Attn",
            "B-Checks_Address1",
            "B-Checks_Address2",
            "B-Checks_CityStateZip",

            "TransactionProcedure_Oral",
            "TransactionProcedure_Written",
            "ConfirmDeadline_BusinessDays2",
            "ConfirmDeadline_BusinessDaysOther",
            "ConfirmDeadline_BusinessDaysOtherInfo",
            "ConfirmingParty_Seller",
            "ConfirmingParty_Buyer",
            "ConfirmingParty_Us",
            "ConfirmingParty_Them",
            "PerformanceObligation_CoverStandard",
            "PerformanceObligation_SpotPriceStandard",
            "SpotPricePublication_DailyGasMidpoint",
            "SpotPricePublication_Other",
            "SpotPricePublication_OtherInfo",
            "Taxes_BuyerPaysAtAndAfter",
            "Taxes_SellerPaysBeforeAndAt",
            "PaymentDate_DayOfMonthFollowingMonthOfDelivery25",
            "PaymentDate_DayOfMonthFollowingMonthOfDelivery28",
            "PaymentDate_DayOfMonthFollowingMonthOfDeliveryOther",
            "PaymentDate_DayOfMonthFollowingMonthOfDeliveryOtherInfo",
            "MethodOfPayment_Wire",
            "MethodOfPayment_ACH",
            "MethodOfPayment_Check",
            "NettingAppliesTrue",
            "NettingAppliesFalse",
            "AdditionalEventsOfDefault_None",
            "AdditionalEventsOfDefault_Indebtedness",
            "AdditionalEventsOfDefault_IndebtednessPartyA",
            "AdditionalEventsOfDefault_IndebtednessPartyAInfo",
            "AdditionalEventsOfDefault_IndebtednessPartyB",
            "AdditionalEventsOfDefault_IndebtednessPartyBInfo",
            "AdditionalEventsOfDefault_Transactional",
            "AdditionalEventsOfDefault_TransactionalSpecifiedTransactions",
            "EarlyTerminationDamagesApplyTrue",
            "EarlyTerminationDamagesApplyFalse",
            "OtherAgreementSetoffs_Apply",
            "OtherAgreementSetoffs_Bilateral",
            "OtherAgreementSetoffs_Triangular",
            "OtherAgreementSetoffs_DoNotApply",
            "ChoiceOfLaw_State",
            "ConfidentialityAppliesTrue",
            "ConfidentialityAppliesFalse",
            "SpecialProvisions",
            "SpecialExhibits",
            "SpecialProvisions_Detail",
            "Addendums",
            "Addendums_Detail",


            "A-BankName", //begin ExhibitC fields
            "A-CityState",
            "A-AbaNumWire",
            "A-AbaNumAch",
            "A-AccountName",
            "A-AccountNum",
            "A-CreditName",
            "A-FurtherCredit",
            "A-BankNameAlt1",
            "A-CityStateAlt1",
            "A-AbaNumWireAlt1",
            "A-AbaNumAchAlt1",
            "A-AccountNameAlt1",
            "A-AccountNumAlt1",
            "A-CreditNameAlt1",
            "A-FurtherCreditAlt1",
            "A-BankNameAlt2",
            "A-CityStateAlt2",
            "A-AbaNumWireAlt2",
            "A-AbaNumAchAlt2",
            "A-AccountNameAlt2",
            "A-AccountNumAlt2",
            "A-CreditNameAlt2",
            "A-FurtherCreditAlt2",
            "A-CheckHeader",
            "A-CheckName",
            "A-CheckAddress1",
            "A-CheckAddress2",
            "A-CheckCityStateZip",

            "B-BankName",
            "B-CityState",
            "B-AbaNumWire",
            "B-AbaNumAch",
            "B-AccountName",
            "B-AccountNum",
            "B-CreditName",
            "B-FurtherCredit",
            "B-BankNameAlt1",
            "B-CityStateAlt1",
            "B-AbaNumWireAlt1",
            "B-AbaNumAchAlt1",
            "B-AccountNameAlt1",
            "B-AccountNumAlt1",
            "B-CreditNameAlt1",
            "B-FurtherCreditAlt1",
            "B-BankNameAlt2",
            "B-CityStateAlt2",
            "B-AbaNumWireAlt2",
            "B-AbaNumAchAlt2",
            "B-AccountNameAlt2",
            "B-AccountNumAlt2",
            "B-CreditNameAlt2",
            "B-FurtherCreditAlt2",
            "B-CheckHeader",
            "B-CheckName",
            "B-CheckAddress1",
            "B-CheckAddress2",
            "B-CheckCityStateZip" //end ExhibitC fields
        };

        return keys;
    }
}
