﻿using Fast.Shared.Logic.FileService;
using Fast.Shared.Logic.Package;

namespace Fast.Logic;

public class ContractDocNaesb(IFileService fileService, string filesFolderName, string templatesFolderName, string signaturesFolderName, MyDbContext db)
    : DocBaseOpenXml(fileService, filesFolderName, templatesFolderName, signaturesFolderName, string.Empty, true)
{
    protected override string TemplateFileName => "NAESB 2006.docx";

    public async Task Generate(int mainContractId)
    {
        var cpty = await (
           from q in db.Contracts
           where q.Id == mainContractId
           select new
           {
               InternalEntityId = q.InternalEntityId,
               ProductId = q.ProductId,
               q.SignerId,
               q.ContractName,
               q.ContractNum,
               q.EffectiveDate,
               q.ExecutionDate,
               AmendmentDate = q.ContractNaesb == null ? null : q.ContractNaesb.AmendmentDate,
               ContractSignerName = q.Signer == null ? "" : q.Signer.LegalName,
               ContractSignerTitle = q.Signer == null ? "" : q.Signer.Title,
               q.Counterparty.Name,
               q.Counterparty.AddressLine1,
               q.Counterparty.AddressLine2,
               q.Counterparty.City,
               State = q.Counterparty.State == null ? "" : q.Counterparty.State.Name,
               q.Counterparty.Zip,
               q.Counterparty.Website,
               q.Counterparty.CounterpartyDuns,
               q.Counterparty.FederalTaxId,
               Jurisdiction = q.Counterparty.Jurisdiction == null ? "" : q.Counterparty.Jurisdiction.Name,
               q.Counterparty.BusinessTypeId,
               CommercialAddressLine1 = q.ContractContact == null ? null : q.ContractContact.CommercialAddressLine1,
               CommercialAddressLine2 = q.ContractContact == null ? null : q.ContractContact.CommercialAddressLine2,
               CommercialCity = q.ContractContact == null ? null : q.ContractContact.CommercialCity,
               CommercialState = q.ContractContact == null ? null : q.ContractContact.CommercialState == null ? "" : q.ContractContact.CommercialState.Name,
               CommercialZip = q.ContractContact == null ? null : q.ContractContact.CommercialZip,
               CommercialAttn = q.ContractContact == null ? null : q.ContractContact.CommercialAttn,
               CommercialTelephoneNum = q.ContractContact == null ? null : q.ContractContact.CommercialTelephoneNum,
               CommercialFaxNum = q.ContractContact == null ? null : q.ContractContact.CommercialFaxNum,
               CommercialEmailAddress = q.ContractContact == null ? null : q.ContractContact.CommercialEmailAddress,
               SchedulingAddressLine1 = q.ContractContact == null ? null : q.ContractContact.SchedulingAddressLine1,
               SchedulingAddressLine2 = q.ContractContact == null ? null : q.ContractContact.SchedulingAddressLine2,
               SchedulingCity = q.ContractContact == null ? null : q.ContractContact.SchedulingCity,
               SchedulingState = q.ContractContact == null ? null : q.ContractContact.SchedulingState == null ? "" : q.ContractContact.SchedulingState.Name,
               SchedulingZip = q.ContractContact == null ? null : q.ContractContact.SchedulingZip,
               SchedulingAttn = q.ContractContact == null ? null : q.ContractContact.SchedulingAttn,
               SchedulingTelephoneNum = q.ContractContact == null ? null : q.ContractContact.SchedulingTelephoneNum,
               SchedulingFaxNum = q.ContractContact == null ? null : q.ContractContact.SchedulingFaxNum,
               SchedulingEmailAddress = q.ContractContact == null ? null : q.ContractContact.SchedulingEmailAddress,
               NoticesAddressLine1 = q.ContractContact == null ? null : q.ContractContact.NoticesAddressLine1,
               NoticesAddressLine2 = q.ContractContact == null ? null : q.ContractContact.NoticesAddressLine2,
               NoticesCity = q.ContractContact == null ? null : q.ContractContact.NoticesCity,
               NoticesState = q.ContractContact == null ? null : q.ContractContact.NoticesState == null ? "" : q.ContractContact.NoticesState.Name,
               NoticesZip = q.ContractContact == null ? null : q.ContractContact.NoticesZip,
               NoticesAttn = q.ContractContact == null ? null : q.ContractContact.NoticesAttn,
               NoticesTelephoneNum = q.ContractContact == null ? null : q.ContractContact.NoticesTelephoneNum,
               NoticesFaxNum = q.ContractContact == null ? null : q.ContractContact.NoticesFaxNum,
               NoticesEmailAddress = q.ContractContact == null ? null : q.ContractContact.NoticesEmailAddress,
               CreditAddressLine1 = q.ContractContact == null ? null : q.ContractContact.CreditAddressLine1,
               CreditAddressLine2 = q.ContractContact == null ? null : q.ContractContact.CreditAddressLine2,
               CreditCity = q.ContractContact == null ? null : q.ContractContact.CreditCity,
               CreditState = q.ContractContact == null ? null : q.ContractContact.CreditState == null ? "" : q.ContractContact.CreditState.Name,
               CreditZip = q.ContractContact == null ? null : q.ContractContact.CreditZip,
               CreditAttn = q.ContractContact == null ? null : q.ContractContact.CreditAttn,
               CreditTelephoneNum = q.ContractContact == null ? null : q.ContractContact.CreditTelephoneNum,
               CreditFaxNum = q.ContractContact == null ? null : q.ContractContact.CreditFaxNum,
               CreditEmailAddress = q.ContractContact == null ? null : q.ContractContact.CreditEmailAddress,
               ConfirmationsAddressLine1 = q.ContractContact == null ? null : q.ContractContact.ConfirmationsAddressLine1,
               ConfirmationsAddressLine2 = q.ContractContact == null ? null : q.ContractContact.ConfirmationsAddressLine2,
               ConfirmationsCity = q.ContractContact == null ? null : q.ContractContact.ConfirmationsCity,
               ConfirmationsState = q.ContractContact == null ? null : q.ContractContact.ConfirmationsState == null ? "" : q.ContractContact.ConfirmationsState.Name,
               ConfirmationsZip = q.ContractContact == null ? null : q.ContractContact.ConfirmationsZip,
               ConfirmationsAttn = q.ContractContact == null ? null : q.ContractContact.ConfirmationsAttn,
               ConfirmationsTelephoneNum = q.ContractContact == null ? null : q.ContractContact.ConfirmationsTelephoneNum,
               ConfirmationsFaxNum = q.ContractContact == null ? null : q.ContractContact.ConfirmationsFaxNum,
               ConfirmationsEmailAddress = q.ContractContact == null ? null : q.ContractContact.ConfirmationsEmailAddress,
               InvoiceAddressLine1 = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceAddressLine1,
               InvoiceAddressLine2 = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceAddressLine2,
               InvoiceCity = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceCity,
               InvoiceState = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceState == null ? "" : q.ContractAccounting.InvoiceState.Name,
               InvoiceZip = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceZip,
               InvoiceAttn = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceAttn,
               InvoiceTelephoneNum = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceTelephoneNum,
               InvoiceFaxNum = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceFaxNum,
               InvoiceEmailAddress = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceEmailAddress,
               WireBankName = q.ContractAccounting == null ? null : q.ContractAccounting.WireBankName,
               WireAbaNum = q.ContractAccounting == null ? null : q.ContractAccounting.WireAbaNum,
               WireAccountNum = q.ContractAccounting == null ? null : q.ContractAccounting.WireAccountNum,
               WireOtherDetails = q.ContractAccounting == null ? null : q.ContractAccounting.WireOtherDetails,
               AchBank = q.ContractAccounting == null ? null : q.ContractAccounting.AchBank,
               AchAbaNum = q.ContractAccounting == null ? null : q.ContractAccounting.AchAbaNum,
               AchAccountNum = q.ContractAccounting == null ? null : q.ContractAccounting.AchAccountNum,
               AchOtherDetails = q.ContractAccounting == null ? null : q.ContractAccounting.AchOtherDetails,
               ChecksAttn = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksAttn,
               ChecksAddressLine1 = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksAddressLine1,
               ChecksAddressLine2 = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksAddressLine2,
               ChecksCity = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksCity,
               ChecksState = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksState == null ? "" : q.ContractAccounting.ChecksState.Name,
               ChecksZip = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksZip,
               TransactionProcedureTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.TransactionProcedureTypeId,
               ConfirmDeadline = q.ContractNaesb == null ? null : q.ContractNaesb.ConfirmDeadline,
               ConfirmingPartyTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.ConfirmingPartyTypeId,
               PerformanceObligationTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.PerformanceObligationTypeId,
               SpotPricePublicationTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.SpotPricePublicationTypeId,
               SpotPricePublicationOther = q.ContractNaesb == null ? null : q.ContractNaesb.SpotPricePublicationOther,
               TaxesOptionId = q.ContractNaesb == null ? null : q.ContractNaesb.TaxesOptionId,
               PaymentDateOptionId = q.ContractNaesb == null ? null : q.ContractNaesb.PaymentDateOptionId,
               PaymentDateType = q.ContractNaesb == null ? null : q.ContractNaesb.PaymentDateType == null ? "" : q.ContractNaesb.PaymentDateType.Name,
               WireTransferPayment = q.ContractNaesb == null ? false : q.ContractNaesb.WireTransferPayment,
               AchPayment = q.ContractNaesb == null ? false : q.ContractNaesb.AchPayment,
               CheckPayment = q.ContractNaesb == null ? false : q.ContractNaesb.CheckPayment,
               NettingTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.NettingTypeId,
               AdditionalEventTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.AdditionalEventTypeId,
               EarlyTerminationTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.EarlyTerminationTypeId,
               OtherAgreementSetoffsTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.OtherAgreementSetoffsTypeId,
               ChoiceOfLaw = q.ContractNaesb == null ? null : q.ContractNaesb.ChoiceOfLaw,
               ConfidentialityTypeId = q.ContractNaesb == null ? null : q.ContractNaesb.ConfidentialityTypeId,
               AddendumExhibitB = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitB,
               AddendumExhibitC = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitC,
               AddendumExhibitD = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitD,
               AddendumExhibitE = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitE,
               AddendumExhibitF = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitF,
               AddendumExhibitG = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitG,
               AddendumExhibitH = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitH,
               AddendumExhibitI = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitI,
               AddendumExhibitJ = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitJ,
               AddendumExhibitK = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitK,
               AddendumExhibitL = q.ContractNaesb == null ? false : q.ContractNaesb.AddendumExhibitL
           }
       ).AsNoTracking().FirstAsync();

        var intrnl = await (
            from q in db.Contracts
            where q.IsInternalSideOfContract
                    && q.InternalEntityId == cpty.InternalEntityId
                    && q.ProductId == cpty.ProductId
            select new
            {
                q.InternalEntity.Name,
                q.InternalEntity.AddressLine1,
                q.InternalEntity.AddressLine2,
                q.InternalEntity.City,
                State = q.InternalEntity.State == null ? "" : q.InternalEntity.State.Name,
                q.InternalEntity.Zip,
                q.InternalEntity.Website,
                q.InternalEntity.CounterpartyDuns,
                q.InternalEntity.FederalTaxId,
                Jurisdiction = q.InternalEntity.Jurisdiction == null ? "" : q.InternalEntity.Jurisdiction.Name,
                q.InternalEntity.BusinessTypeId,
                CommercialAddressLine1 = q.ContractContact == null ? null : q.ContractContact.CommercialAddressLine1,
                CommercialAddressLine2 = q.ContractContact == null ? null : q.ContractContact.CommercialAddressLine2,
                CommercialCity = q.ContractContact == null ? null : q.ContractContact.CommercialCity,
                CommercialState = q.ContractContact == null ? "" : q.ContractContact.CommercialState == null ? "" : q.ContractContact.CommercialState.Name,
                CommercialZip = q.ContractContact == null ? null : q.ContractContact.CommercialZip,
                CommercialAttn = q.ContractContact == null ? null : q.ContractContact.CommercialAttn,
                CommercialTelephoneNum = q.ContractContact == null ? null : q.ContractContact.CommercialTelephoneNum,
                CommercialFaxNum = q.ContractContact == null ? null : q.ContractContact.CommercialFaxNum,
                CommercialEmailAddress = q.ContractContact == null ? null : q.ContractContact.CommercialEmailAddress,
                SchedulingAddressLine1 = q.ContractContact == null ? null : q.ContractContact.SchedulingAddressLine1,
                SchedulingAddressLine2 = q.ContractContact == null ? null : q.ContractContact.SchedulingAddressLine2,
                SchedulingCity = q.ContractContact == null ? null : q.ContractContact.SchedulingCity,
                SchedulingState = q.ContractContact == null ? "" : q.ContractContact.SchedulingState == null ? "" : q.ContractContact.SchedulingState.Name,
                SchedulingZip = q.ContractContact == null ? null : q.ContractContact.SchedulingZip,
                SchedulingAttn = q.ContractContact == null ? null : q.ContractContact.SchedulingAttn,
                SchedulingTelephoneNum = q.ContractContact == null ? null : q.ContractContact.SchedulingTelephoneNum,
                SchedulingFaxNum = q.ContractContact == null ? null : q.ContractContact.SchedulingFaxNum,
                SchedulingEmailAddress = q.ContractContact == null ? null : q.ContractContact.SchedulingEmailAddress,
                NoticesAddressLine1 = q.ContractContact == null ? null : q.ContractContact.NoticesAddressLine1,
                NoticesAddressLine2 = q.ContractContact == null ? null : q.ContractContact.NoticesAddressLine2,
                NoticesCity = q.ContractContact == null ? null : q.ContractContact.NoticesCity,
                NoticesState = q.ContractContact == null ? "" : q.ContractContact.NoticesState == null ? "" : q.ContractContact.NoticesState.Name,
                NoticesZip = q.ContractContact == null ? null : q.ContractContact.NoticesZip,
                NoticesAttn = q.ContractContact == null ? null : q.ContractContact.NoticesAttn,
                NoticesTelephoneNum = q.ContractContact == null ? null : q.ContractContact.NoticesTelephoneNum,
                NoticesFaxNum = q.ContractContact == null ? null : q.ContractContact.NoticesFaxNum,
                NoticesEmailAddress = q.ContractContact == null ? null : q.ContractContact.NoticesEmailAddress,
                CreditAddressLine1 = q.ContractContact == null ? null : q.ContractContact.CreditAddressLine1,
                CreditAddressLine2 = q.ContractContact == null ? null : q.ContractContact.CreditAddressLine2,
                CreditCity = q.ContractContact == null ? null : q.ContractContact.CreditCity,
                CreditState = q.ContractContact == null ? "" : q.ContractContact.CreditState == null ? "" : q.ContractContact.CreditState.Name,
                CreditZip = q.ContractContact == null ? null : q.ContractContact.CreditZip,
                CreditAttn = q.ContractContact == null ? null : q.ContractContact.CreditAttn,
                CreditTelephoneNum = q.ContractContact == null ? null : q.ContractContact.CreditTelephoneNum,
                CreditFaxNum = q.ContractContact == null ? null : q.ContractContact.CreditFaxNum,
                CreditEmailAddress = q.ContractContact == null ? null : q.ContractContact.CreditEmailAddress,
                ConfirmationsAddressLine1 = q.ContractContact == null ? null : q.ContractContact.ConfirmationsAddressLine1,
                ConfirmationsAddressLine2 = q.ContractContact == null ? null : q.ContractContact.ConfirmationsAddressLine2,
                ConfirmationsCity = q.ContractContact == null ? null : q.ContractContact.ConfirmationsCity,
                ConfirmationsState = q.ContractContact == null ? "" : q.ContractContact.ConfirmationsState == null ? "" : q.ContractContact.ConfirmationsState.Name,
                ConfirmationsZip = q.ContractContact == null ? null : q.ContractContact.ConfirmationsZip,
                ConfirmationsAttn = q.ContractContact == null ? null : q.ContractContact.ConfirmationsAttn,
                ConfirmationsTelephoneNum = q.ContractContact == null ? null : q.ContractContact.ConfirmationsTelephoneNum,
                ConfirmationsFaxNum = q.ContractContact == null ? null : q.ContractContact.ConfirmationsFaxNum,
                ConfirmationsEmailAddress = q.ContractContact == null ? null : q.ContractContact.ConfirmationsEmailAddress,
                InvoiceAddressLine1 = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceAddressLine1,
                InvoiceAddressLine2 = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceAddressLine2,
                InvoiceCity = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceCity,
                InvoiceState = q.ContractAccounting == null ? "" : q.ContractAccounting.InvoiceState == null ? "" : q.ContractAccounting.InvoiceState.Name,
                InvoiceZip = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceZip,
                InvoiceAttn = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceAttn,
                InvoiceTelephoneNum = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceTelephoneNum,
                InvoiceFaxNum = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceFaxNum,
                InvoiceEmailAddress = q.ContractAccounting == null ? null : q.ContractAccounting.InvoiceEmailAddress,
                WireBankName = q.ContractAccounting == null ? null : q.ContractAccounting.WireBankName,
                WireAbaNum = q.ContractAccounting == null ? null : q.ContractAccounting.WireAbaNum,
                WireAccountNum = q.ContractAccounting == null ? null : q.ContractAccounting.WireAccountNum,
                WireOtherDetails = q.ContractAccounting == null ? null : q.ContractAccounting.WireOtherDetails,
                AchBank = q.ContractAccounting == null ? null : q.ContractAccounting.AchBank,
                AchAbaNum = q.ContractAccounting == null ? null : q.ContractAccounting.AchAbaNum,
                AchAccountNum = q.ContractAccounting == null ? null : q.ContractAccounting.AchAccountNum,
                AchOtherDetails = q.ContractAccounting == null ? null : q.ContractAccounting.AchOtherDetails,
                ChecksAttn = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksAttn,
                ChecksAddressLine1 = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksAddressLine1,
                ChecksAddressLine2 = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksAddressLine2,
                ChecksCity = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksCity,
                ChecksState = q.ContractAccounting == null ? "" : q.ContractAccounting.ChecksState == null ? "" : q.ContractAccounting.ChecksState.Name,
                ChecksZip = q.ContractAccounting == null ? null : q.ContractAccounting.ChecksZip,

            }
        ).AsNoTracking().FirstAsync();

        var c = cpty;
        var i = intrnl;

        const string BankInfoOnExCstr = "All bank info is specified on Exhibit C";

        SetText("EffectiveDateShort", c.EffectiveDate?.ToShortDateString() ?? "");
        SetText("EffectiveDateLong", c.EffectiveDate?.ToString(ContractHelper.dateLongFormat) ?? "");
        SetText("ExecutionDateShort", c.EffectiveDate?.ToShortDateString() ?? "");
        SetText("ExecutionDateLong", c.EffectiveDate?.ToString(ContractHelper.dateLongFormat) ?? "");
        SetText("LastAmendmentDateShort", c.AmendmentDate?.ToShortDateString() ?? "");
        SetText("LastAmendmentDateLong", c.AmendmentDate?.ToString(ContractHelper.dateLongFormat) ?? "");
        SetText("ContractSignerName", c.ContractSignerName);
        SetText("ContractSignerTitle", c.ContractSignerTitle);

        SetText("A-Name", i.Name);
        SetText("A-Address1", i.AddressLine1);
        SetText("A-Address2", i.AddressLine2);
        SetText("A-CityStateZip", ContractHelper.GetCityStateZipStr(i.City, i.State, i.Zip));
        SetText("A-BusinessWebsite", i.Website);
        SetText("A-ContractNumberA", c.ContractNum);
        SetText("A-DUNSNumber", string.Join(",", i.CounterpartyDuns.Select(x => x.Duns)));
        SetText("A-FederalTaxID", !string.IsNullOrWhiteSpace(i.FederalTaxId) ? "X" : "--");
        SetText("A-FederalTaxIDNumber", i.FederalTaxId);
        SetText("A-OtherTaxID", "--");
        SetText("A-OtherTaxIDNumber", "");
        SetText("A-Jurisdiction", i.Jurisdiction);
        SetText("A-CompanyTypeCorporation", i.BusinessTypeId == (int)Enums.BusinessType.Corporation ? "X" : "--");
        SetText("A-CompanyTypeLLC", i.BusinessTypeId == (int)Enums.BusinessType.LLC ? "X" : "--");
        SetText("A-CompanyTypeLP", i.BusinessTypeId == (int)Enums.BusinessType.LP ? "X" : "--");
        SetText("A-CompanyTypePartnership", i.BusinessTypeId == (int)Enums.BusinessType.Partnership ? "X" : "--");
        SetText("A-CompanyTypeLLP", i.BusinessTypeId == (int)Enums.BusinessType.LLP ? "X" : "--");
        SetText("A-CompanyTypeOther", i.BusinessTypeId == (int)Enums.BusinessType.Other ? "X" : "--");
        SetText("A-CompanyTypeOtherInfo", "");
        SetText("A-Guarantor", "");
        SetText("A-Commercial_Address1", i.CommercialAddressLine1);
        SetText("A-Commercial_Address2", i.CommercialAddressLine2);
        SetText("A-Commercial_CityStateZip", ContractHelper.GetCityStateZipStr(i.CommercialCity, i.CommercialState, i.CommercialZip));
        SetText("A-Commercial_Attn", i.CommercialAttn);
        SetText("A-Commercial_Telephone", i.CommercialTelephoneNum);
        SetText("A-Commercial_Fax", i.CommercialFaxNum);
        SetText("A-Commercial_Email", i.CommercialEmailAddress);
        SetText("A-Scheduling_Address1", i.SchedulingAddressLine1);
        SetText("A-Scheduling_Address2", i.SchedulingAddressLine2);
        SetText("A-Scheduling_CityStateZip", ContractHelper.GetCityStateZipStr(i.SchedulingCity, i.SchedulingState, i.SchedulingZip));
        SetText("A-Scheduling_Attn", i.SchedulingAttn);
        SetText("A-Scheduling_Telephone", i.SchedulingTelephoneNum);
        SetText("A-Scheduling_Fax", i.SchedulingFaxNum);
        SetText("A-Scheduling_Email", i.SchedulingEmailAddress);
        SetText("A-Notices_Address1", i.NoticesAddressLine1);
        SetText("A-Notices_Address2", i.NoticesAddressLine2);
        SetText("A-Notices_CityStateZip", ContractHelper.GetCityStateZipStr(i.NoticesCity, i.NoticesState, i.NoticesZip));
        SetText("A-Notices_Attn", i.NoticesAttn);
        SetText("A-Notices_Telephone", i.NoticesTelephoneNum);
        SetText("A-Notices_Fax", i.NoticesFaxNum);
        SetText("A-Notices_Email", i.NoticesEmailAddress);
        SetText("A-Credit_Address1", i.CreditAddressLine1);
        SetText("A-Credit_Address2", i.CreditAddressLine2);
        SetText("A-Credit_CityStateZip", ContractHelper.GetCityStateZipStr(i.CreditCity, i.CreditState, i.CreditZip));
        SetText("A-Credit_Attn", i.CreditAttn);
        SetText("A-Credit_Telephone", i.CreditTelephoneNum);
        SetText("A-Credit_Fax", i.CreditFaxNum);
        SetText("A-Credit_Email", i.CreditEmailAddress);
        SetText("A-Confirmations_Address1", i.ConfirmationsAddressLine1);
        SetText("A-Confirmations_Address2", i.ConfirmationsAddressLine2);
        SetText("A-Confirmations_CityStateZip", ContractHelper.GetCityStateZipStr(i.ConfirmationsCity, i.ConfirmationsState, i.ConfirmationsZip));
        SetText("A-Confirmations_Attn", i.ConfirmationsAttn);
        SetText("A-Confirmations_Telephone", i.ConfirmationsTelephoneNum);
        SetText("A-Confirmations_Fax", i.ConfirmationsFaxNum);
        SetText("A-Confirmations_Email", i.ConfirmationsEmailAddress);
        SetText("A-Invoices_Address1", i.InvoiceAddressLine1);
        SetText("A-Invoices_Address2", i.InvoiceAddressLine2);
        SetText("A-Invoices_CityStateZip", ContractHelper.GetCityStateZipStr(i.InvoiceCity, i.InvoiceState, i.InvoiceZip));
        SetText("A-Invoices_Attn", i.InvoiceAttn);
        SetText("A-Invoices_Telephone", i.InvoiceTelephoneNum);
        SetText("A-Invoices_Fax", i.InvoiceFaxNum);
        SetText("A-Invoices_Email", i.InvoiceEmailAddress);
        SetText("A-WireTransfer_Bank", !c.AddendumExhibitC ? i.WireBankName : BankInfoOnExCstr);
        SetText("A-WireTransfer_ABA", !c.AddendumExhibitC ? i.WireAbaNum : "");
        SetText("A-WireTransfer_Acct", !c.AddendumExhibitC ? i.WireAccountNum : "");
        SetText("A-WireTransfer_OtherDetails", !c.AddendumExhibitC ? i.WireOtherDetails : "");
        SetText("A-ACH_Bank", !c.AddendumExhibitC ? i.AchBank : BankInfoOnExCstr);
        SetText("A-ACH_ABA", !c.AddendumExhibitC ? i.AchAbaNum : "");
        SetText("A-ACH_Acct", !c.AddendumExhibitC ? i.AchAccountNum : "");
        SetText("A-ACH_OtherDetails", !c.AddendumExhibitC ? i.AchOtherDetails : "");
        SetText("A-Checks_Attn", !c.AddendumExhibitC ? i.ChecksAttn : "");
        SetText("A-Checks_Address1", !c.AddendumExhibitC ? i.ChecksAddressLine1 : "");
        SetText("A-Checks_Address2", !c.AddendumExhibitC ? i.ChecksAddressLine2 : "");
        SetText("A-Checks_CityStateZip", !c.AddendumExhibitC ? ContractHelper.GetCityStateZipStr(i.ChecksCity, i.ChecksState, i.ChecksZip) : "");

        SetText("B-Name", c.Name);
        SetText("B-Address1", c.AddressLine1);
        SetText("B-Address2", c.AddressLine2);
        SetText("B-CityStateZip", ContractHelper.GetCityStateZipStr(c.City, c.State, c.Zip));
        SetText("B-BusinessWebsite", c.Website);
        SetText("B-ContractNumberB", "");
        SetText("B-DUNSNumber", string.Join(",", c.CounterpartyDuns.Select(x => x.Duns)));
        SetText("B-FederalTaxID", !string.IsNullOrWhiteSpace(c.FederalTaxId) ? "X" : "--");
        SetText("B-FederalTaxIDNumber", c.FederalTaxId);
        SetText("B-OtherTaxID", "--");
        SetText("B-OtherTaxIDNumber", "");
        SetText("B-Jurisdiction", c.Jurisdiction);
        SetText("B-CompanyTypeCorporation", c.BusinessTypeId == (int)Enums.BusinessType.Corporation ? "X" : "--");
        SetText("B-CompanyTypeLLC", c.BusinessTypeId == (int)Enums.BusinessType.LLC ? "X" : "--");
        SetText("B-CompanyTypeLP", c.BusinessTypeId == (int)Enums.BusinessType.LP ? "X" : "--");
        SetText("B-CompanyTypePartnership", c.BusinessTypeId == (int)Enums.BusinessType.Partnership ? "X" : "--");
        SetText("B-CompanyTypeLLP", c.BusinessTypeId == (int)Enums.BusinessType.LLP ? "X" : "--");
        SetText("B-CompanyTypeOther", c.BusinessTypeId == (int)Enums.BusinessType.Other ? "X" : "--");
        SetText("B-CompanyTypeOtherInfo", "");
        SetText("B-Guarantor", "");
        SetText("B-Commercial_Address1", c.CommercialAddressLine1);
        SetText("B-Commercial_Address2", c.CommercialAddressLine2);
        SetText("B-Commercial_CityStateZip", ContractHelper.GetCityStateZipStr(c.CommercialCity, c.CommercialState, c.CommercialZip));
        SetText("B-Commercial_Attn", c.CommercialAttn);
        SetText("B-Commercial_Telephone", c.CommercialTelephoneNum);
        SetText("B-Commercial_Fax", c.CommercialFaxNum);
        SetText("B-Commercial_Email", c.CommercialEmailAddress);
        SetText("B-Scheduling_Address1", c.SchedulingAddressLine1);
        SetText("B-Scheduling_Address2", c.SchedulingAddressLine2);
        SetText("B-Scheduling_CityStateZip", ContractHelper.GetCityStateZipStr(c.SchedulingCity, c.SchedulingState, c.SchedulingZip));
        SetText("B-Scheduling_Attn", c.SchedulingAttn);
        SetText("B-Scheduling_Telephone", c.SchedulingTelephoneNum);
        SetText("B-Scheduling_Fax", c.SchedulingFaxNum);
        SetText("B-Scheduling_Email", c.SchedulingEmailAddress);
        SetText("B-Notices_Address1", c.NoticesAddressLine1);
        SetText("B-Notices_Address2", c.NoticesAddressLine2);
        SetText("B-Notices_CityStateZip", ContractHelper.GetCityStateZipStr(c.NoticesCity, c.NoticesState, c.NoticesZip));
        SetText("B-Notices_Attn", c.NoticesAttn);
        SetText("B-Notices_Telephone", c.NoticesTelephoneNum);
        SetText("B-Notices_Fax", c.NoticesFaxNum);
        SetText("B-Notices_Email", c.NoticesEmailAddress);
        SetText("B-Credit_Address1", c.CreditAddressLine1);
        SetText("B-Credit_Address2", c.CreditAddressLine2);
        SetText("B-Credit_CityStateZip", ContractHelper.GetCityStateZipStr(c.CreditCity, c.CreditState, c.CreditZip));
        SetText("B-Credit_Attn", c.CreditAttn);
        SetText("B-Credit_Telephone", c.CreditTelephoneNum);
        SetText("B-Credit_Fax", c.CreditFaxNum);
        SetText("B-Credit_Email", c.CreditEmailAddress);
        SetText("B-Confirmations_Address1", c.ConfirmationsAddressLine1);
        SetText("B-Confirmations_Address2", c.ConfirmationsAddressLine2);
        SetText("B-Confirmations_CityStateZip", ContractHelper.GetCityStateZipStr(c.ConfirmationsCity, c.ConfirmationsState, c.ConfirmationsZip));
        SetText("B-Confirmations_Attn", c.ConfirmationsAttn);
        SetText("B-Confirmations_Telephone", c.ConfirmationsTelephoneNum);
        SetText("B-Confirmations_Fax", c.ConfirmationsFaxNum);
        SetText("B-Confirmations_Email", c.ConfirmationsEmailAddress);
        SetText("B-Invoices_Address1", c.InvoiceAddressLine1);
        SetText("B-Invoices_Address2", c.InvoiceAddressLine2);
        SetText("B-Invoices_CityStateZip", ContractHelper.GetCityStateZipStr(c.InvoiceCity, c.InvoiceState, c.InvoiceZip));
        SetText("B-Invoices_Attn", c.InvoiceAttn);
        SetText("B-Invoices_Telephone", c.InvoiceTelephoneNum);
        SetText("B-Invoices_Fax", c.InvoiceFaxNum);
        SetText("B-Invoices_Email", c.InvoiceEmailAddress);
        SetText("B-WireTransfer_Bank", !c.AddendumExhibitC ? c.WireBankName : BankInfoOnExCstr);
        SetText("B-WireTransfer_ABA", !c.AddendumExhibitC ? c.WireAbaNum : "");
        SetText("B-WireTransfer_Acct", !c.AddendumExhibitC ? c.WireAccountNum : "");
        SetText("B-WireTransfer_OtherDetails", !c.AddendumExhibitC ? c.WireOtherDetails : "");
        SetText("B-ACH_Bank", !c.AddendumExhibitC ? c.AchBank : BankInfoOnExCstr);
        SetText("B-ACH_ABA", !c.AddendumExhibitC ? c.AchAbaNum : "");
        SetText("B-ACH_Acct", !c.AddendumExhibitC ? c.AchAccountNum : "");
        SetText("B-ACH_OtherDetails", !c.AddendumExhibitC ? c.AchOtherDetails : "");
        SetText("B-Checks_Attn", !c.AddendumExhibitC ? c.ChecksAttn : "");
        SetText("B-Checks_Address1", !c.AddendumExhibitC ? c.ChecksAddressLine1 : "");
        SetText("B-Checks_Address2", !c.AddendumExhibitC ? c.ChecksAddressLine2 : "");
        SetText("B-Checks_CityStateZip", !c.AddendumExhibitC ? ContractHelper.GetCityStateZipStr(c.ChecksCity, c.ChecksState, c.ChecksZip) : "");

        SetText("TransactionProcedure_Oral", c.TransactionProcedureTypeId == 1 ? "X" : "--");
        SetText("TransactionProcedure_Written", c.TransactionProcedureTypeId == 2 ? "X" : "--");
        SetText("ConfirmDeadline_BusinessDays2", c.ConfirmDeadline.GetValueOrDefault() == 2 ? "X" : "--");
        SetText("ConfirmDeadline_BusinessDaysOther", c.ConfirmDeadline.GetValueOrDefault() != 2 ? "X" : "--");
        SetText("ConfirmDeadline_BusinessDaysOtherInfo", c.ConfirmDeadline.GetValueOrDefault() != 2 ? c.ConfirmDeadline.ToString() ?? "" : "");
        SetText("ConfirmingParty_Seller", c.ConfirmingPartyTypeId == 1 ? "X" : "--");
        SetText("ConfirmingParty_Buyer", c.ConfirmingPartyTypeId == 2 ? "X" : "--");
        SetText("ConfirmingParty_Us", c.ConfirmingPartyTypeId == 3 ? "X" : "--");
        SetText("ConfirmingParty_Them", c.ConfirmingPartyTypeId == 4 ? "X" : "--");
        SetText("PerformanceObligation_CoverStandard", c.PerformanceObligationTypeId == 1 ? "X" : "--");
        SetText("PerformanceObligation_SpotPriceStandard", c.PerformanceObligationTypeId == 2 ? "X" : "--");
        SetText("SpotPricePublication_DailyGasMidpoint", c.SpotPricePublicationTypeId == 1 ? "X" : "--");
        SetText("SpotPricePublication_Other", c.SpotPricePublicationTypeId == 2 ? "X" : "--");
        SetText("SpotPricePublication_OtherInfo", c.SpotPricePublicationOther);
        SetText("Taxes_BuyerPaysAtAndAfter", c.TaxesOptionId == 1 ? "X" : "--");
        SetText("Taxes_SellerPaysBeforeAndAt", c.TaxesOptionId == 2 ? "X" : "--");
        SetText("PaymentDate_DayOfMonthFollowingMonthOfDelivery25", c.PaymentDateOptionId == 2 ? "X" : "--");
        SetText("PaymentDate_DayOfMonthFollowingMonthOfDelivery28", c.PaymentDateOptionId == 3 ? "X" : "--");
        SetText("PaymentDate_DayOfMonthFollowingMonthOfDeliveryOther", c.PaymentDateOptionId == 1 || c.PaymentDateOptionId == 4 ? "X" : "--");
        SetText("PaymentDate_DayOfMonthFollowingMonthOfDeliveryOtherInfo", c.PaymentDateOptionId == 1 ? "20th" : c.PaymentDateOptionId == 4 ? c.PaymentDateType : "");
        SetText("MethodOfPayment_Wire", c.WireTransferPayment ? "X" : "--");
        SetText("MethodOfPayment_ACH", c.AchPayment ? "X" : "--");
        SetText("MethodOfPayment_Check", c.CheckPayment ? "X" : "--");
        SetText("NettingAppliesTrue", c.NettingTypeId == 1 ? "X" : "--");
        SetText("NettingAppliesFalse", c.NettingTypeId == 2 ? "X" : "--");
        SetText("AdditionalEventsOfDefault_None", c.AdditionalEventTypeId == 1 ? "X" : "--");
        SetText("AdditionalEventsOfDefault_Indebtedness", c.AdditionalEventTypeId == 2 ? "X" : "--");
        SetText("AdditionalEventsOfDefault_IndebtednessPartyA", "");
        SetText("AdditionalEventsOfDefault_IndebtednessPartyAInfo", "");
        SetText("AdditionalEventsOfDefault_IndebtednessPartyB", "");
        SetText("AdditionalEventsOfDefault_IndebtednessPartyBInfo", "");
        SetText("AdditionalEventsOfDefault_Transactional", c.AdditionalEventTypeId == 3 ? "X" : "--");
        SetText("AdditionalEventsOfDefault_TransactionalSpecifiedTransactions", "");
        SetText("EarlyTerminationDamagesApplyTrue", c.EarlyTerminationTypeId == 1 ? "X" : "--");
        SetText("EarlyTerminationDamagesApplyFalse", c.EarlyTerminationTypeId == 2 ? "X" : "--");
        SetText("OtherAgreementSetoffs_Apply", c.OtherAgreementSetoffsTypeId == 1 || c.OtherAgreementSetoffsTypeId == 2 ? "X" : "--");
        SetText("OtherAgreementSetoffs_Bilateral", c.OtherAgreementSetoffsTypeId == 1 ? "X" : "--");
        SetText("OtherAgreementSetoffs_Triangular", c.OtherAgreementSetoffsTypeId == 2 ? "X" : "--");
        SetText("OtherAgreementSetoffs_DoNotApply", c.OtherAgreementSetoffsTypeId == 3 ? "X" : "--");
        SetText("ChoiceOfLaw_State", c.ChoiceOfLaw);
        SetText("ConfidentialityAppliesTrue", c.ConfidentialityTypeId == 1 ? "X" : "--");
        SetText("ConfidentialityAppliesFalse", c.ConfidentialityTypeId == 2 ? "X" : "--");

        List<string> exhibits = new List<string>();

        //Exhibit B goes under Special Provisions
        //All other Exhibits go under Addendums
        if (c.AddendumExhibitC) exhibits.Add("Exhibit C");
        if (c.AddendumExhibitD) exhibits.Add("Exhibit D");
        if (c.AddendumExhibitE) exhibits.Add("Exhibit E");
        if (c.AddendumExhibitF) exhibits.Add("Exhibit F");
        if (c.AddendumExhibitG) exhibits.Add("Exhibit G");
        if (c.AddendumExhibitH) exhibits.Add("Exhibit H");
        if (c.AddendumExhibitI) exhibits.Add("Exhibit I");
        if (c.AddendumExhibitJ) exhibits.Add("Exhibit J");
        if (c.AddendumExhibitK) exhibits.Add("Exhibit K");
        if (c.AddendumExhibitL) exhibits.Add("Exhibit L");

        string addendumsText = string.Join(", ", exhibits);

        SetText("SpecialProvisions", c.AddendumExhibitB ? "X" : "--");
        SetText("SpecialExhibits", c.AddendumExhibitB ? "Exhibit B" : "");
        SetText("SpecialProvisions_Detail", c.AddendumExhibitB ? "" : "");  //This is for the number of pages. Bryce will fill it in.

        SetText("Addendums", !string.IsNullOrWhiteSpace(addendumsText) ? "X" : "--");
        SetText("Addendums_Detail", addendumsText);

        string fileNameOriginal = $"{c.ContractName}-{c.ContractNum}-NAESB2006.docx";
        fileNameOriginal = Util.String.GetLegalFileName(fileNameOriginal);
        string fileNameOnDisk = Util.String.GetNewGuid() + ".docx";

        wordprocessingDocument.PackageProperties.Title = fileNameOriginal;

        // Use SaveToMemoryStream and write via fileService - sharding is handled internally
        var docStream = SaveToMemoryStream();
        var docBytes = docStream.ToArray();
        var uploadedFileName = await fileService.WriteAllBytesAsync(filesFolderName, fileNameOnDisk, docBytes);

        if (!string.IsNullOrWhiteSpace(uploadedFileName))
        {
            var newDoc = new ContractDoc
            {
                ContractId = mainContractId,
                FileNameOriginal = fileNameOriginal,
                FileNameOnDisk = uploadedFileName,
                InactiveDate = null
            };
            db.ContractDocs.Add(newDoc);
            await db.SaveChangesAsync();
        }

    }

    protected override HashSet<string> GetDocKeys()
    {
        return ContractHelper.GetDocKeys();
    }
}
