﻿using Fast.Shared.Logic.FileService;
using Fast.Shared.Logic.Package;

namespace Fast.Logic;

public class ContractDocExC(IFileService fileService, string filesFolderName, string templatesFolderName, string signaturesFolderName, MyDbContext db)
    : DocBaseOpenXml(fileService, filesFolderName, templatesFolderName, signaturesFolderName, string.Empty, true)
{
    protected override string TemplateFileName => "NAESBExhibitC.docx";

    public async Task Generate(int mainContractId)
    {

        var cpty = await (
            from q in db.Contracts
            where q.Id == mainContractId
            select new
            {
                AmendmentDate = q.ContractExhibitC == null ? null : q.ContractExhibitC.AmendmentDate,
                InternalEntityId = q.InternalEntityId,
                ProductId = q.ProductId,
                q.SignerId,
                q.ContractName,
                q.ContractNum,
                q.EffectiveDate,
                q.ExecutionDate,
                ContractSignerName = q.Signer == null ? null : q.Signer.LegalName,
                ContractSignerTitle = q.Signer == null ? null : q.Signer.Title,
                q.Counterparty.Name,
                BankName = q.ContractExhibitC == null ? null : q.ContractExhibitC.BankName,
                CityState = q.ContractExhibitC == null ? null : q.ContractExhibitC.CityState,
                AbaNumWire = q.ContractExhibitC == null ? null : q.ContractExhibitC.AbaNumWire,
                AbaNumAch = q.ContractExhibitC == null ? null : q.ContractExhibitC.AbaNumAch,
                AccountName = q.ContractExhibitC == null ? null : q.ContractExhibitC.AccountName,
                AccountNum = q.ContractExhibitC == null ? null : q.ContractExhibitC.AccountNum,
                CreditName = q.ContractExhibitC == null ? null : q.ContractExhibitC.CreditName,
                ForFurtherCreditTo = q.ContractExhibitC == null ? null : q.ContractExhibitC.ForFurtherCreditTo,
                Alt1BankName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1BankName,
                Alt1CityState = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1CityState,
                Alt1AbaNumWire = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AbaNumWire,
                Alt1AbaNumAch = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AbaNumAch,
                Alt1AccountName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AccountName,
                Alt1AccountNum = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AccountNum,
                Alt1CreditName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1CreditName,
                Alt1ForFurtherCreditTo = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1ForFurtherCreditTo,
                Alt2BankName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2BankName,
                Alt2CityState = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2CityState,
                Alt2AbaNumWire = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AbaNumWire,
                Alt2AbaNumAch = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AbaNumAch,
                Alt2AccountName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AccountName,
                Alt2AccountNum = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AccountNum,
                Alt2CreditName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2CreditName,
                Alt2ForFurtherCreditTo = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2ForFurtherCreditTo,
                CheckPaymentAddressLine1 = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentAddressLine1,
                CheckPaymentAddressLine2 = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentAddressLine2,
                CheckPaymentCity = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentCity,
                CheckPaymentCountry = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentCountry.Name,
                CheckPaymentState = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentState == null ? null : q.ContractExhibitC.CheckPaymentState.Name,
                CheckPaymentZip = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentZip
            }
        ).AsNoTracking().FirstOrDefaultAsync();

        var intrnl = await (
            from q in db.Contracts
            where q.ContractExhibitC != null && q.IsInternalSideOfContract
                && cpty != null && q.InternalEntityId == cpty.InternalEntityId
                && q.ProductId == cpty.ProductId
            select new
            {
                q.InternalEntity.Name,
                BankName = q.ContractExhibitC == null ? null : q.ContractExhibitC.BankName,
                CityState = q.ContractExhibitC == null ? null : q.ContractExhibitC.CityState,
                AbaNumWire = q.ContractExhibitC == null ? null : q.ContractExhibitC.AbaNumWire,
                AbaNumAch = q.ContractExhibitC == null ? null : q.ContractExhibitC.AbaNumAch,
                AccountName = q.ContractExhibitC == null ? null : q.ContractExhibitC.AccountName,
                AccountNum = q.ContractExhibitC == null ? null : q.ContractExhibitC.AccountNum,
                CreditName = q.ContractExhibitC == null ? null : q.ContractExhibitC.CreditName,
                ForFurtherCreditTo = q.ContractExhibitC == null ? null : q.ContractExhibitC.ForFurtherCreditTo,
                Alt1BankName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1BankName,
                Alt1CityState = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1CityState,
                Alt1AbaNumWire = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AbaNumWire,
                Alt1AbaNumAch = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AbaNumAch,
                Alt1AccountName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AccountName,
                Alt1AccountNum = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1AccountNum,
                Alt1CreditName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1CreditName,
                Alt1ForFurtherCreditTo = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt1ForFurtherCreditTo,
                Alt2BankName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2BankName,
                Alt2CityState = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2CityState,
                Alt2AbaNumWire = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AbaNumWire,
                Alt2AbaNumAch = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AbaNumAch,
                Alt2AccountName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AccountName,
                Alt2AccountNum = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2AccountNum,
                Alt2CreditName = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2CreditName,
                Alt2ForFurtherCreditTo = q.ContractExhibitC == null ? null : q.ContractExhibitC.Alt2ForFurtherCreditTo,
                CheckPaymentAddressLine1 = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentAddressLine1,
                CheckPaymentAddressLine2 = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentAddressLine2,
                CheckPaymentCity = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentCity,
                CheckPaymentCountry = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentCountry.Name,
                CheckPaymentState = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentState == null ? null : q.ContractExhibitC.CheckPaymentState.Name,
                CheckPaymentZip = q.ContractExhibitC == null ? null : q.ContractExhibitC.CheckPaymentZip,
                AmendmentDate = q.ContractExhibitC == null ? null : q.ContractExhibitC.AmendmentDate,
            }
        ).AsNoTracking().FirstOrDefaultAsync();

        if (cpty == null || intrnl == null)
        {
            return;
        }

        var c = cpty;
        var i = intrnl;

        var latestAmendmentDate = new List<DateOnly?>()
            {
                c.AmendmentDate,
                i.AmendmentDate
            }.Max();

        SetText("A-Name", i.Name);
        SetText("B-Name", c.Name);
        SetText("EffectiveDateShort", c.EffectiveDate?.ToShortDateString() ?? "");
        SetText("EffectiveDateLong", c.EffectiveDate?.ToString(ContractHelper.dateLongFormat) ?? "");
        SetText("ExecutionDateShort", c.EffectiveDate?.ToShortDateString() ?? "");
        SetText("ExecutionDateLong", c.EffectiveDate?.ToString(ContractHelper.dateLongFormat) ?? "");
        SetText("LastAmendmentDateShort", latestAmendmentDate?.ToShortDateString() ?? "");
        SetText("LastAmendmentDateLong", latestAmendmentDate?.ToString(ContractHelper.dateLongFormat) ?? "");
        SetText("ContractSignerName", c.ContractSignerName);
        SetText("ContractSignerTitle", c.ContractSignerTitle);


        SetText("A-BankName", i.BankName, true);
        SetText("A-CityState", i.CityState, true);
        SetText("A-AbaNumWire", i.AbaNumWire, true);
        SetText("A-AbaNumAch", i.AbaNumAch, true);
        SetText("A-AccountName", i.AccountName, true);
        SetText("A-AccountNum", i.AccountNum, true);
        SetText("A-CreditName", i.CreditName, true);
        SetText("A-FurtherCredit", i.ForFurtherCreditTo, true);
        SetText("A-BankNameAlt1", i.Alt1BankName, true);
        SetText("A-CityStateAlt1", i.Alt1CityState, true);
        SetText("A-AbaNumWireAlt1", i.Alt1AbaNumWire, true);
        SetText("A-AbaNumAchAlt1", i.Alt1AbaNumAch, true);
        SetText("A-AccountNameAlt1", i.Alt1AccountName, true);
        SetText("A-AccountNumAlt1", i.Alt1AccountNum, true);
        SetText("A-CreditNameAlt1", i.Alt1CreditName, true);
        SetText("A-FurtherCreditAlt1", i.Alt1ForFurtherCreditTo, true);
        SetText("A-BankNameAlt2", i.Alt2BankName, true);
        SetText("A-CityStateAlt2", i.Alt2CityState, true);
        SetText("A-AbaNumWireAlt2", i.Alt2AbaNumWire, true);
        SetText("A-AbaNumAchAlt2", i.Alt2AbaNumAch, true);
        SetText("A-AccountNameAlt2", i.Alt2AccountName, true);
        SetText("A-AccountNumAlt2", i.Alt2AccountNum, true);
        SetText("A-CreditNameAlt2", i.Alt2CreditName, true);
        SetText("A-FurtherCreditAlt2", i.Alt2ForFurtherCreditTo, true);

        SetText("B-BankName", c.BankName, true);
        SetText("B-CityState", c.CityState, true);
        SetText("B-AbaNumWire", c.AbaNumWire, true);
        SetText("B-AbaNumAch", c.AbaNumAch, true);
        SetText("B-AccountName", c.AccountName, true);
        SetText("B-AccountNum", c.AccountNum, true);
        SetText("B-CreditName", c.CreditName, true);
        SetText("B-FurtherCredit", c.ForFurtherCreditTo, true);
        SetText("B-BankNameAlt1", c.Alt1BankName, true);
        SetText("B-CityStateAlt1", c.Alt1CityState, true);
        SetText("B-AbaNumWireAlt1", c.Alt1AbaNumWire, true);
        SetText("B-AbaNumAchAlt1", c.Alt1AbaNumAch, true);
        SetText("B-AccountNameAlt1", c.Alt1AccountName, true);
        SetText("B-AccountNumAlt1", c.Alt1AccountNum, true);
        SetText("B-CreditNameAlt1", c.Alt1CreditName, true);
        SetText("B-FurtherCreditAlt1", c.Alt1ForFurtherCreditTo, true);
        SetText("B-BankNameAlt2", c.Alt2BankName, true);
        SetText("B-CityStateAlt2", c.Alt2CityState, true);
        SetText("B-AbaNumWireAlt2", c.Alt2AbaNumWire, true);
        SetText("B-AbaNumAchAlt2", c.Alt2AbaNumAch, true);
        SetText("B-AccountNameAlt2", c.Alt2AccountName, true);
        SetText("B-AccountNumAlt2", c.Alt2AccountNum, true);
        SetText("B-CreditNameAlt2", c.Alt2CreditName, true);
        SetText("B-FurtherCreditAlt2", c.Alt2ForFurtherCreditTo, true);

        string checkHeader = "Check Payment Instructions:";
        bool hasCheckPayment;
        string cityStateZipStr;

        hasCheckPayment = !string.IsNullOrWhiteSpace(i.CheckPaymentAddressLine1);
        SetText("A-CheckHeader", hasCheckPayment ? checkHeader : "", true);
        SetText("A-CheckName", hasCheckPayment ? i.Name : "", true);
        SetText("A-CheckAddress1", hasCheckPayment ? i.CheckPaymentAddressLine1 : "", true);
        SetText("A-CheckAddress2", hasCheckPayment ? i.CheckPaymentAddressLine2 : "", true);
        cityStateZipStr = ContractHelper.GetCityStateZipStr(i.CheckPaymentCity, i.CheckPaymentState, i.CheckPaymentZip);
        SetText("A-CheckCityStateZip", hasCheckPayment ? cityStateZipStr : "", true);

        hasCheckPayment = !string.IsNullOrWhiteSpace(c.CheckPaymentAddressLine1);
        SetText("B-CheckHeader", hasCheckPayment ? checkHeader : "", true);
        SetText("B-CheckName", hasCheckPayment ? c.Name : "", true);
        SetText("B-CheckAddress1", hasCheckPayment ? c.CheckPaymentAddressLine1 : "", true);
        SetText("B-CheckAddress2", hasCheckPayment ? c.CheckPaymentAddressLine2 : "", true);
        cityStateZipStr = ContractHelper.GetCityStateZipStr(c.CheckPaymentCity, c.CheckPaymentState, c.CheckPaymentZip);
        SetText("B-CheckCityStateZip", hasCheckPayment ? cityStateZipStr : "", true);

        string fileNameOriginal = $"{c.ContractName}-{c.ContractNum}-ExhibitC.docx";
        fileNameOriginal = Util.String.GetLegalFileName(fileNameOriginal);
        string fileNameOnDisk = Guid.NewGuid().ToString("N") + ".docx";

        wordprocessingDocument.PackageProperties.Title = fileNameOriginal;

        // Use SaveToMemoryStream and write via fileService - sharding is handled internally
        var docStream = SaveToMemoryStream();
        var docBytes = docStream.ToArray();
        var uploadedFileName = await fileService.WriteAllBytesAsync(filesFolderName, fileNameOnDisk, docBytes);

        if (!string.IsNullOrWhiteSpace(uploadedFileName))
        {
            var newDoc = new ContractDoc
            {
                ContractId = mainContractId,
                FileNameOriginal = fileNameOriginal,
                FileNameOnDisk = uploadedFileName,
                InactiveDate = null
            };
            db.ContractDocs.Add(newDoc);
            await db.SaveChangesAsync();
        }

    }

    protected override HashSet<string> GetDocKeys()
    {
        return ContractHelper.GetDocKeys();
    }
}
