using Fast.Models;

namespace Fast.Web.Controllers;

[Authorize]
[ApiController]
[Route("api/[controller]")]
public class OtherInfoController : Controller
{
    private readonly MyDbContext db;

    private readonly AuthorizationHelper authHelper;

    public OtherInfoController(MyDbContext context)
    {
        db = context;
        authHelper = new AuthorizationHelper(Main.IsAuthenticationEnabled);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetRequiredData()
    {
        var hasModifyPermission = await authHelper.IsAuthorizedAsync(User, "Main Contract", PermissionType.Modify);
        var result = new { hasModifyPermission };
        return Ok(result);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetOtherInfo(int internalEntityId, int productId)
    {
        var dbItem = await (
            from q in db.Contracts
            where q.IsInternalSideOfContract
                && q.InternalEntityId == internalEntityId
                && q.ProductId == productId
            select q.ContractOther
        ).AsNoTracking().FirstOrDefaultAsync() ?? new ContractOther();

        MainContractOtherInfoDetail d = new();
        d.LcLanguage = dbItem.LcLanguage;
        d.AgentClause = dbItem.AgentClause;

        return Ok(d);
    }
}

