using Fast.Models;

namespace Fast.Web.Controllers;

[Authorize]
[ApiController]
[Route("api/[controller]")]
public class Naesb2006Controller : Controller
{
    private readonly MyDbContext db;

    private readonly AuthorizationHelper authHelper;

    public Naesb2006Controller(MyDbContext context)
    {
        db = context;
        authHelper = new AuthorizationHelper(Main.IsAuthenticationEnabled);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetRequiredData()
    {
        var states = await DataHelper.GetTerritoriesAsync();
        var countries = await (from q in db.Countries orderby q.Id == 1 descending, q.Name select new IdName(q.Id, q.Name)).ToListAsync();
        var payments = await (from q in db.PaymentDateTypes orderby q.Id select new IdName(q.Id, q.Name ?? "")).ToListAsync();
        var hasModifyPermission = await authHelper.IsAuthorizedAsync(User, "Main Contract", PermissionType.Modify);
        var result = new { states, countries, payments, hasModifyPermission };
        return Ok(result);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetNaesbInfo(int contractId)
    {
        var dbItem = await (
            from q in db.Contracts
                .Include(x => x.ContractNaesb)
            where q.Id == contractId
            select q.ContractNaesb
        ).AsNoTracking().FirstOrDefaultAsync() ?? GetNewNaesbInfo();

        MainContractNaesbInfoDetail d = new();
        d.TransactionProcedureTypeId = dbItem.TransactionProcedureTypeId;
        d.ConfirmDeadline = dbItem.ConfirmDeadline;
        d.ConfirmingPartyTypeId = dbItem.ConfirmingPartyTypeId;
        d.PerformanceObligationTypeId = dbItem.PerformanceObligationTypeId;
        d.SpotPricePublicationTypeId = dbItem.SpotPricePublicationTypeId;
        d.TaxesOptionId = dbItem.TaxesOptionId;
        d.PaymentDateOptionId = dbItem.PaymentDateOptionId;
        d.WireTransferPayment = dbItem.WireTransferPayment;
        d.AchPayment = dbItem.AchPayment;
        d.CheckPayment = dbItem.CheckPayment;
        d.NettingTypeId = dbItem.NettingTypeId;
        d.AdditionalEventTypeId = dbItem.AdditionalEventTypeId;
        d.EarlyTerminationTypeId = dbItem.EarlyTerminationTypeId;
        d.OtherAgreementSetoffsTypeId = dbItem.OtherAgreementSetoffsTypeId;
        d.ChoiceOfLaw = dbItem.ChoiceOfLaw;
        d.ConfidentialityTypeId = dbItem.ConfidentialityTypeId;
        d.AddendumExhibitB = dbItem.AddendumExhibitB;
        d.AddendumExhibitC = dbItem.AddendumExhibitC;
        d.AddendumExhibitD = dbItem.AddendumExhibitD;
        d.AddendumExhibitE = dbItem.AddendumExhibitE;
        d.AddendumExhibitF = dbItem.AddendumExhibitF;
        d.AddendumExhibitG = dbItem.AddendumExhibitG;
        d.AddendumExhibitH = dbItem.AddendumExhibitH;
        d.AddendumExhibitI = dbItem.AddendumExhibitI;
        d.AddendumExhibitJ = dbItem.AddendumExhibitJ;
        d.AddendumExhibitK = dbItem.AddendumExhibitK;
        d.AddendumExhibitL = dbItem.AddendumExhibitL;
        d.PaymentDateTypeId = dbItem.PaymentDateTypeId;
        d.SpotPricePublicationOther = dbItem.SpotPricePublicationOther;
        d.AmendmentDate = dbItem.AmendmentDate;

        return Ok(d);
    }

    internal static ContractNaesb GetNewNaesbInfo()
    {
        var newNaesbInfo = new ContractNaesb
        {
            AchPayment = true,
            AddendumExhibitB = false,
            AddendumExhibitC = false,
            AddendumExhibitD = false,
            AddendumExhibitE = false,
            AddendumExhibitF = false,
            AddendumExhibitG = false,
            AddendumExhibitH = false,
            AddendumExhibitI = false,
            AddendumExhibitJ = false,
            AddendumExhibitK = false,
            AddendumExhibitL = false,
            AdditionalEventTypeId = 1,
            OtherAgreementSetoffsTypeId = 1,
            CheckPayment = false,
            ChoiceOfLaw = null,
            ConfidentialityTypeId = 1,
            ConfirmDeadline = 2,
            ConfirmingPartyTypeId = 3,
            EarlyTerminationTypeId = 1,
            NettingTypeId = 1,
            PaymentDateOptionId = 2,
            PerformanceObligationTypeId = 2,
            SpotPricePublicationTypeId = 1,
            TaxesOptionId = 1,
            TransactionProcedureTypeId = 1,
            WireTransferPayment = true,
            PaymentDateTypeId = null,
            SpotPricePublicationOther = null,
            AmendmentDate = null
        };

        return newNaesbInfo;
    }
}

