namespace Fast.Web.Controllers;

[Authorize]
[ApiController]
[Route("api/[controller]")]
public class FilterControlController : ControllerBase
{
    public FilterControlController()
    {
    }

    [Permission("Report Center", PermissionType.View)]
    [Route("[action]")]
    public IActionResult GetPlants()
    {
        var items = DataHelper.GetPlantsAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetProducers()
    {
        var items = await DataHelper.GetProducersAsync(false);
        return Ok(items);
    }

    [Permission("Report Center", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetMeters()
    {
        var items = (await DataHelper.GetMetersByProductAsync(Enums.ProductCategory.All))
            .Select(x => new IdName(x.MeterId, x.MeterName))
            .Distinct();

        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetPriceIndexes()
    {
        var items = await DataHelper.GetIndexesAsync(true, false, Enums.ProductCategory.All);
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetCounterparties()
    {
        var items = (await DataHelper.GetCounterpartiesAsync(false, Enums.ProductCategory.All)).Select(x => new IdName(x.EntityId, x.FullName)).ToList();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetBooks()
    {
        var items = await DataHelper.GetBooksAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetBrokers()
    {
        var items = await DataHelper.GetBrokersAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetBrokerAccounts()
    {
        var items = await DataHelper.GetBrokerAccountsAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetProducts()
    {
        var items = await DataHelper.GetProductsAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetDealPurposes()
    {
        var items = await DataHelper.GetDealPurposesAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetDealStatuses()
    {
        var items = await DataHelper.GetDealStatusesAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetDealTypes()
    {
        var items = await DataHelper.GetDealTypesAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetInternalEntities()
    {
        var items = await DataHelper.GetInternalEntitiesOldAsync(false);
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetPipelines()
    {
        var items = (await DataHelper.GetPipelinesAsync(true)).Select(x => new IdName(x.PipeId, x.PipeName));
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetPoints()
    {
        var items = (await DataHelper.GetPointsAsync(true, Enums.ProductCategory.All)).Select(x => new IdName(x.PointId, x.PointName));
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetPortfolios()
    {
        var items = await DataHelper.GetPortfoliosAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetRegions()
    {
        var items = await DataHelper.GetRegionsAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetStrategies()
    {
        var items = await DataHelper.GetStrategiesAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetTraders()
    {
        var items = await DataHelper.GetTradersAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetTransactionTypes()
    {
        var items = await DataHelper.GetTransactionTypesAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetBlocks()
    {
        var items = await DataHelper.GetLeasesAsync();
        return Ok(items);
    }

    [Permission("Deal", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetProductGroups()
    {
        var items = await DataHelper.GetProductCategoriesAsync();
        return Ok(items);
    }
}
