using System.Data.Common;
using Fast.Models;

namespace Fast.Web.Controllers;


[Authorize]
[ApiController]
[Route("api/[controller]")]
public class ExhibitCInfoController : Controller
{
    private readonly MyDbContext db;
    private readonly AuthorizationHelper authHelper;

    public ExhibitCInfoController(MyDbContext context)
    {
        db = context;
        authHelper = new AuthorizationHelper(Main.IsAuthenticationEnabled);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetRequiredData()
    {
        var states = await DataHelper.GetTerritoriesAsync();
        var countries = await (from q in db.Countries orderby q.Id == 1 descending, q.Name select new IdName(q.Id, q.Name)).ToListAsync();
        var hasModifyPermission = await authHelper.IsAuthorizedAsync(User, "Main Contract", PermissionType.Modify);
        var result = new { states, countries, hasModifyPermission };
        return Ok(result);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetExhibitCInfo(int contractId, bool getInternalSide, int entityId, int productId)
    {
        ContractExhibitC dbItem;

        if (getInternalSide)
        {
            dbItem = await (
                from q in db.Contracts
                where q.IsInternalSideOfContract
                    && q.InternalEntityId == entityId
                    && q.ProductId == productId
                select q.ContractExhibitC
            ).AsNoTracking().FirstOrDefaultAsync() ?? new ContractExhibitC();
        }
        else
        {
            dbItem = await (
                from q in db.Contracts
                where q.Id == contractId
                select q.ContractExhibitC
            ).AsNoTracking().FirstOrDefaultAsync() ?? new ContractExhibitC();
        }

        MainContractExhibitCDetail d = new();
        d.BankName = dbItem.BankName;
        d.CityState = dbItem.CityState;
        d.AbaNumWire = dbItem.AbaNumWire;
        d.AbaNumAch = dbItem.AbaNumAch;
        d.AccountName = dbItem.AccountName;
        d.ForFurtherCreditTo = dbItem.ForFurtherCreditTo;
        d.CreditName = dbItem.CreditName;
        d.AccountNum = dbItem.AccountNum;
        d.Alt1BankName = dbItem.Alt1BankName;
        d.Alt1CityState = dbItem.Alt1CityState;
        d.Alt1AbaNumWire = dbItem.Alt1AbaNumWire;
        d.Alt1AbaNumAch = dbItem.Alt1AbaNumAch;
        d.Alt1AccountName = dbItem.Alt1AccountName;
        d.Alt1ForFurtherCreditTo = dbItem.Alt1ForFurtherCreditTo;
        d.Alt1CreditName = dbItem.Alt1CreditName;
        d.Alt1AccountNum = dbItem.Alt1AccountNum;
        d.Alt2BankName = dbItem.Alt2BankName;
        d.Alt2CityState = dbItem.Alt2CityState;
        d.Alt2AbaNumWire = dbItem.Alt2AbaNumWire;
        d.Alt2AbaNumAch = dbItem.Alt2AbaNumAch;
        d.Alt2AccountName = dbItem.Alt2AccountName;
        d.Alt2ForFurtherCreditTo = dbItem.Alt2ForFurtherCreditTo;
        d.Alt2CreditName = dbItem.Alt2CreditName;
        d.Alt2AccountNum = dbItem.Alt2AccountNum;
        d.CheckPaymentAddressLine1 = dbItem.CheckPaymentAddressLine1;
        d.CheckPaymentAddressLine2 = dbItem.CheckPaymentAddressLine2;
        d.CheckPaymentCountryId = dbItem.CheckPaymentCountryId;
        d.CheckPaymentCity = dbItem.CheckPaymentCity;
        d.CheckPaymentStateId = dbItem.CheckPaymentStateId;
        d.CheckPaymentZip = dbItem.CheckPaymentZip;
        d.AmendmentDate = dbItem.AmendmentDate;

        return Ok(d);
    }
}
