namespace Fast.Web.Controllers;
using Fast.Models;

[Authorize]
[ApiController]
[Route("api/[controller]")]
public class ContactInfoController : Controller
{
    private readonly MyDbContext db;
    private readonly AuthorizationHelper authHelper;
    public ContactInfoController(MyDbContext context)
    {
        db = context;
        authHelper = new AuthorizationHelper(Main.IsAuthenticationEnabled);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetRequiredData()
    {
        var states = await DataHelper.GetTerritoriesAsync();
        var countries = await (from q in db.Countries orderby q.Id == 1 descending, q.Name select new IdName(q.Id, q.Name)).ToListAsync();
        var hasModifyPermission = await authHelper.IsAuthorizedAsync(User, "Main Contract", PermissionType.Modify);
        var result = new { states, countries, hasModifyPermission };
        return Ok(result);
    }

    [Permission("Main Contract", PermissionType.View)]
    [Route("[action]")]
    public async Task<IActionResult> GetContactInfo(int contractId, bool getInternalSide, int entityId, int productId)
    {
        ContractContact dbItem;
        if (getInternalSide)
        {
            dbItem = await (
                from q in db.Contracts
                where q.IsInternalSideOfContract
                    && q.InternalEntityId == entityId
                    && q.ProductId == productId
                select q.ContractContact
            ).AsNoTracking().FirstOrDefaultAsync() ?? new ContractContact();
        }
        else
        {
            dbItem = await (
               from q in db.Contracts
               where q.Id == contractId
               select q.ContractContact
           ).AsNoTracking().FirstOrDefaultAsync() ?? new ContractContact();
        }

        MainContractContactDetail d = new();
        d.CommercialAddressLine1 = dbItem.CommercialAddressLine1;
        d.CommercialAddressLine2 = dbItem.CommercialAddressLine2;
        d.CommercialCountryId = dbItem.CommercialCountryId;
        d.CommercialCity = dbItem.CommercialCity;
        d.CommercialStateId = dbItem.CommercialStateId;
        d.CommercialZip = dbItem.CommercialZip;
        d.CommercialAttn = dbItem.CommercialAttn;
        d.CommercialTelephoneNum = dbItem.CommercialTelephoneNum;
        d.CommercialFaxNum = dbItem.CommercialFaxNum;
        d.CommercialEmailAddress = dbItem.CommercialEmailAddress;
        d.SchedulingAddressLine1 = dbItem.SchedulingAddressLine1;
        d.SchedulingAddressLine2 = dbItem.SchedulingAddressLine2;
        d.SchedulingCountryId = dbItem.SchedulingCountryId;
        d.SchedulingCity = dbItem.SchedulingCity;
        d.SchedulingStateId = dbItem.SchedulingStateId;
        d.SchedulingZip = dbItem.SchedulingZip;
        d.SchedulingAttn = dbItem.SchedulingAttn;
        d.SchedulingTelephoneNum = dbItem.SchedulingTelephoneNum;
        d.SchedulingFaxNum = dbItem.SchedulingFaxNum;
        d.SchedulingEmailAddress = dbItem.SchedulingEmailAddress;
        d.NoticesAddressLine1 = dbItem.NoticesAddressLine1;
        d.NoticesAddressLine2 = dbItem.NoticesAddressLine2;
        d.NoticesCountryId = dbItem.NoticesCountryId;
        d.NoticesCity = dbItem.NoticesCity;
        d.NoticesStateId = dbItem.NoticesStateId;
        d.NoticesZip = dbItem.NoticesZip;
        d.NoticesAttn = dbItem.NoticesAttn;
        d.NoticesTelephoneNum = dbItem.NoticesTelephoneNum;
        d.NoticesFaxNum = dbItem.NoticesFaxNum;
        d.NoticesEmailAddress = dbItem.NoticesEmailAddress;
        d.CreditAddressLine1 = dbItem.CreditAddressLine1;
        d.CreditAddressLine2 = dbItem.CreditAddressLine2;
        d.CreditCountryId = dbItem.CreditCountryId;
        d.CreditCity = dbItem.CreditCity;
        d.CreditStateId = dbItem.CreditStateId;
        d.CreditZip = dbItem.CreditZip;
        d.CreditAttn = dbItem.CreditAttn;
        d.CreditTelephoneNum = dbItem.CreditTelephoneNum;
        d.CreditFaxNum = dbItem.CreditFaxNum;
        d.CreditEmailAddress = dbItem.CreditEmailAddress;
        d.ConfirmationsAddressLine1 = dbItem.ConfirmationsAddressLine1;
        d.ConfirmationsAddressLine2 = dbItem.ConfirmationsAddressLine2;
        d.ConfirmationsCountryId = dbItem.ConfirmationsCountryId;
        d.ConfirmationsCity = dbItem.ConfirmationsCity;
        d.ConfirmationsStateId = dbItem.ConfirmationsStateId;
        d.ConfirmationsZip = dbItem.ConfirmationsZip;
        d.ConfirmationsAttn = dbItem.ConfirmationsAttn;
        d.ConfirmationsTelephoneNum = dbItem.ConfirmationsTelephoneNum;
        d.ConfirmationsFaxNum = dbItem.ConfirmationsFaxNum;
        d.ConfirmationsEmailAddress = dbItem.ConfirmationsEmailAddress;
        d.DoEmail = dbItem.DoEmail;
        d.DoFax = dbItem.DoFax;
        d.CombineEmail = dbItem.CombineEmail;

        return Ok(d);
    }
}

