import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';

export interface MainContractOtherInfoDetail {
  lcLanguage: string;
  agentClause: string;
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class OtherInfoService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/OtherInfo`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getOtherInfo(internalEntityId: number, productId: number): Observable<MainContractOtherInfoDetail> {
    const url = `${this.baseUrl}/GetOtherInfo?internalEntityId=${internalEntityId}&productId=${productId}`;
    return this.http.get<MainContractOtherInfoDetail>(url);
  }
}
