import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../../_shared/utils/util'

export interface MainContractNaesbInfoDetail {
  transactionProcedureTypeId: number;
  confirmDeadline: number;
  confirmingPartyTypeId: number;
  performanceObligationTypeId: number;
  spotPricePublicationTypeId: number;
  taxesOptionId: number;
  paymentDateOptionId: number;
  wireTransferPayment: boolean;
  achPayment: boolean;
  checkPayment: boolean;
  nettingTypeId: number;
  additionalEventTypeId: number;
  earlyTerminationTypeId: number;
  otherAgreementSetoffsTypeId: number;
  choiceOfLaw: string;
  confidentialityTypeId: number;
  addendumExhibitB: boolean;
  addendumExhibitC: boolean;
  addendumExhibitD: boolean;
  addendumExhibitE: boolean;
  addendumExhibitF: boolean;
  addendumExhibitG: boolean;
  addendumExhibitH: boolean;
  addendumExhibitI: boolean;
  addendumExhibitJ: boolean;
  addendumExhibitK: boolean;
  addendumExhibitL: boolean;
  paymentDateTypeId: number;
  spotPricePublicationOther: string
  amendmentDate: Date;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  states: util.IdName[];
  countries: util.IdName[];
  payments: util.IdName[]
}

@Injectable({
  providedIn: 'root'
})
export class Naesb2006Service extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/Naesb2006`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getNaesbInfo(contractId: number): Observable<MainContractNaesbInfoDetail> {
    const url = `${this.baseUrl}/GetNaesbInfo?contractId=${contractId}`;
    return this.http.get<MainContractNaesbInfoDetail>(url);
  }
}
