import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../../_shared/utils/util'

export interface MainContractExhibitCDetail {
  bankName: string;
  cityState: string;
  abaNumWire: string;
  abaNumAch: string;
  accountName: string;
  forFurtherCreditTo: string;
  creditName: string;
  accountNum: string;
  alt1BankName: string;
  alt1CityState: string;
  alt1AbaNumWire: string;
  alt1AbaNumAch: string;
  alt1AccountName: string;
  alt1ForFurtherCreditTo: string;
  alt1CreditName: string;
  alt1AccountNum: string;
  alt2BankName: string;
  alt2CityState: string;
  alt2AbaNumWire: string;
  alt2AbaNumAch: string;
  alt2AccountName: string;
  alt2ForFurtherCreditTo: string;
  alt2CreditName: string;
  alt2AccountNum: string;
  checkPaymentAddressLine1: string;
  checkPaymentAddressLine2: string;
  checkPaymentCountryId: number;
  checkPaymentCity: string;
  checkPaymentStateId: number;
  checkPaymentZip: string;
  amendmentDate: Date;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  states: util.IdName[];
  countries: util.IdName[];
}

@Injectable({
  providedIn: 'root'
})
export class ExhibitCInfoService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/ExhibitCInfo`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getExhibitCInfo(contractId: number, getInternalSide: boolean, entityId: number, productId: number): Observable<MainContractExhibitCDetail> {
    const url = `${this.baseUrl}/GetExhibitCInfo?contractId=${contractId}&getInternalSide=${getInternalSide}&entityId=${entityId}&productId=${productId}`;
    return this.http.get<MainContractExhibitCDetail>(url);
  }
}
