import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../../_shared/utils/util';

export interface MainContractExhibitBInfo {
  exhibitBDetail: MainContractExhibitBDetail;
  exhibitBSelectionDetail: MainContractExhibitBSelectionDetail;
  exhibitBItemsToDelete: MainContractExhibitBItem[];
}

export interface MainContractExhibitBSelectionDetail {
  contractId: number;
  exibhitBSelectedIds: number[];
}

export interface MainContractExhibitBDetail {
  title: string;
  body: string;
  showInactive: boolean;
  items: MainContractExhibitBItem[];
  exhibitBAmendmentDate: Date;
}

export interface MainContractExhibitBItem {
  id: number;
  title: string;
  body: string;
  ordinal: number;
  isContractSpecific: boolean;
  items: MainContractExhibitBItem[];
  parentId: number;
  inactiveDate: Date;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  entities: util.Entity[];
  states: util.IdName[];
}

@Injectable({
  providedIn: 'root'
})
export class ExhibitBInfoService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/ExhibitBInfo`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getExhibitBInfo(contractId: number): Observable<MainContractExhibitBInfo> {
    const url = `${this.baseUrl}/GetExhibitBInfo?contractId=${contractId}`;
    return this.http.get<MainContractExhibitBInfo>(url);
  }
}
