import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';

export interface MainContractEntityDetail {
  companyName: string;
  addressLine1: string;
  addressLine2: string;
  country: string;
  city: string;
  state: string;
  zip: string;
  dunsNum: string;
  federalTaxId: string;
  jurisdiction: string;
  businessType: string;
  relationships: string;
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class EntityInfoService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/EntityInfo`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getEntityInfo(entityId: number): Observable<MainContractEntityDetail> {
    const url = `${this.baseUrl}/GetEntityInfo?entityId=${entityId}`;
    return this.http.get<MainContractEntityDetail>(url);
  }
}
