import { Pipe, PipeTransform } from '@angular/core';
import dayjs from 'dayjs';
import * as util from '../_shared/utils/util';

@Pipe({
  name: 'docInactiveName'
})
export class DocInactivePipe implements PipeTransform {
  transform(doc: util.DocItemWithInactive): string {
    const inactiveDateStr: string = doc.inactiveDate == null ? "" : " Inactivated on " + dayjs(doc.inactiveDate).format("YYYY-MM-DD");
    const name: string = doc.fileNameOriginal + inactiveDateStr;
    return name;
  }
}
