import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../../_shared/utils/util'

export interface MainContractCrudeDetail {
  calcItems: MainContractCrudeCalcItem[];
}

export interface MainContractCrudeCalcItem {
  pipeLossAllowance: number;
  differential: number;
  isDiffBeforePipeLoss: boolean;
  pointIds: number[];
  effectiveDate: Date;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  states: util.IdName[];
  countries: util.IdName[];
  crudePoints: util.IdName[];
}

@Injectable({
  providedIn: 'root'
})
export class CrudeInfoService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/CrudeInfo`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getCrudeInfo(contractId: number): Observable<MainContractCrudeDetail> {
    const url = `${this.baseUrl}/GetCrudeInfo?contractId=${contractId}`;
    return this.http.get<MainContractCrudeDetail>(url);
  }
}
