import { UntypedFormGroup } from '@angular/forms';
import { MainContractContactDetail } from './contact-info.service';

export class ContactContractHelper {
  PasteFromCommercial(contactInfoDetailForm: UntypedFormGroup): void {
    const contactDetail: MainContractContactDetail = contactInfoDetailForm.value;

    contactDetail.schedulingAddressLine1 = contactDetail.commercialAddressLine1;
    contactDetail.noticesAddressLine1 = contactDetail.commercialAddressLine1;
    contactDetail.creditAddressLine1 = contactDetail.commercialAddressLine1;
    contactDetail.confirmationsAddressLine1 = contactDetail.commercialAddressLine1;

    contactDetail.schedulingAddressLine2 = contactDetail.commercialAddressLine2;
    contactDetail.noticesAddressLine2 = contactDetail.commercialAddressLine2;
    contactDetail.creditAddressLine2 = contactDetail.commercialAddressLine2;
    contactDetail.confirmationsAddressLine2 = contactDetail.commercialAddressLine2;

    contactDetail.schedulingCountryId = contactDetail.commercialCountryId;
    contactDetail.noticesCountryId = contactDetail.commercialCountryId;
    contactDetail.creditCountryId = contactDetail.commercialCountryId;
    contactDetail.confirmationsCountryId = contactDetail.commercialCountryId;

    contactDetail.schedulingCity = contactDetail.commercialCity;
    contactDetail.noticesCity = contactDetail.commercialCity;
    contactDetail.creditCity = contactDetail.commercialCity;
    contactDetail.confirmationsCity = contactDetail.commercialCity;

    contactDetail.schedulingStateId = contactDetail.commercialStateId;
    contactDetail.noticesStateId = contactDetail.commercialStateId;
    contactDetail.creditStateId = contactDetail.commercialStateId;
    contactDetail.confirmationsStateId = contactDetail.commercialStateId;

    contactDetail.schedulingZip = contactDetail.commercialZip;
    contactDetail.noticesZip = contactDetail.commercialZip;
    contactDetail.creditZip = contactDetail.commercialZip;
    contactDetail.confirmationsZip = contactDetail.commercialZip;

    contactDetail.schedulingAttn = contactDetail.commercialAttn;
    contactDetail.noticesAttn = contactDetail.commercialAttn;
    contactDetail.creditAttn = contactDetail.commercialAttn;
    contactDetail.confirmationsAttn = contactDetail.commercialAttn;

    contactDetail.schedulingTelephoneNum = contactDetail.commercialTelephoneNum;
    contactDetail.noticesTelephoneNum = contactDetail.commercialTelephoneNum;
    contactDetail.creditTelephoneNum = contactDetail.commercialTelephoneNum;
    contactDetail.confirmationsTelephoneNum = contactDetail.commercialTelephoneNum;

    contactDetail.schedulingFaxNum = contactDetail.commercialFaxNum;
    contactDetail.noticesFaxNum = contactDetail.commercialFaxNum;
    contactDetail.creditFaxNum = contactDetail.commercialFaxNum;
    contactDetail.confirmationsFaxNum = contactDetail.commercialFaxNum;

    contactDetail.schedulingEmailAddress = contactDetail.commercialEmailAddress;
    contactDetail.noticesEmailAddress = contactDetail.commercialEmailAddress;
    contactDetail.creditEmailAddress = contactDetail.commercialEmailAddress;
    contactDetail.confirmationsEmailAddress = contactDetail.commercialEmailAddress;

    contactInfoDetailForm.setValue(contactDetail);
    contactInfoDetailForm.markAsDirty();
  }

  CopyCommercialToScheduling(contactInfoDetailForm: UntypedFormGroup): void {
    const contactDetail: MainContractContactDetail = contactInfoDetailForm.value;

    contactDetail.schedulingAddressLine1 = contactDetail.commercialAddressLine1;
    contactDetail.schedulingAddressLine2 = contactDetail.commercialAddressLine2;
    contactDetail.schedulingCountryId = contactDetail.commercialCountryId;
    contactDetail.schedulingCity = contactDetail.commercialCity;
    contactDetail.schedulingStateId = contactDetail.commercialStateId;
    contactDetail.schedulingZip = contactDetail.commercialZip;
    contactDetail.schedulingAttn = contactDetail.commercialAttn;
    contactDetail.schedulingTelephoneNum = contactDetail.commercialTelephoneNum;
    contactDetail.schedulingFaxNum = contactDetail.commercialFaxNum;
    contactDetail.schedulingEmailAddress = contactDetail.commercialEmailAddress;

    contactInfoDetailForm.setValue(contactDetail);
    contactInfoDetailForm.markAsDirty();
  }

  CopyCommercialToNotices(contactInfoDetailForm: UntypedFormGroup): void {
    const contactDetail: MainContractContactDetail = contactInfoDetailForm.value;

    contactDetail.noticesAddressLine1 = contactDetail.commercialAddressLine1;
    contactDetail.noticesAddressLine2 = contactDetail.commercialAddressLine2;
    contactDetail.noticesCountryId = contactDetail.commercialCountryId;
    contactDetail.noticesCity = contactDetail.commercialCity;
    contactDetail.noticesStateId = contactDetail.commercialStateId;
    contactDetail.noticesZip = contactDetail.commercialZip;
    contactDetail.noticesAttn = contactDetail.commercialAttn;
    contactDetail.noticesTelephoneNum = contactDetail.commercialTelephoneNum;
    contactDetail.noticesFaxNum = contactDetail.commercialFaxNum;
    contactDetail.noticesEmailAddress = contactDetail.commercialEmailAddress;

    contactInfoDetailForm.setValue(contactDetail);
    contactInfoDetailForm.markAsDirty();
  }

  CopyCommercialToCredit(contactInfoDetailForm: UntypedFormGroup): void {
    const contactDetail: MainContractContactDetail = contactInfoDetailForm.value;

    contactDetail.creditAddressLine1 = contactDetail.commercialAddressLine1;
    contactDetail.creditAddressLine2 = contactDetail.commercialAddressLine2;
    contactDetail.creditCountryId = contactDetail.commercialCountryId;
    contactDetail.creditCity = contactDetail.commercialCity;
    contactDetail.creditStateId = contactDetail.commercialStateId;
    contactDetail.creditZip = contactDetail.commercialZip;
    contactDetail.creditAttn = contactDetail.commercialAttn;
    contactDetail.creditTelephoneNum = contactDetail.commercialTelephoneNum;
    contactDetail.creditFaxNum = contactDetail.commercialFaxNum;
    contactDetail.creditEmailAddress = contactDetail.commercialEmailAddress;

    contactInfoDetailForm.setValue(contactDetail);
    contactInfoDetailForm.markAsDirty();
  }

  CopyCommercialToConfirmations(contactInfoDetailForm: UntypedFormGroup): void {
    const contactDetail: MainContractContactDetail = contactInfoDetailForm.value;

    contactDetail.confirmationsAddressLine1 = contactDetail.commercialAddressLine1;
    contactDetail.confirmationsAddressLine2 = contactDetail.commercialAddressLine2;
    contactDetail.confirmationsCountryId = contactDetail.commercialCountryId;
    contactDetail.confirmationsCity = contactDetail.commercialCity;
    contactDetail.confirmationsStateId = contactDetail.commercialStateId;
    contactDetail.confirmationsZip = contactDetail.commercialZip;
    contactDetail.confirmationsAttn = contactDetail.commercialAttn;
    contactDetail.confirmationsTelephoneNum = contactDetail.commercialTelephoneNum;
    contactDetail.confirmationsFaxNum = contactDetail.commercialFaxNum;
    contactDetail.confirmationsEmailAddress = contactDetail.commercialEmailAddress;

    contactInfoDetailForm.setValue(contactDetail);
    contactInfoDetailForm.markAsDirty();
  }
}
