import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../../_shared/utils/util'

export interface MainContractContactDetail {
  commercialAddressLine1: string;
  commercialAddressLine2: string;
  commercialCountryId: number;
  commercialCity: string;
  commercialStateId: number;
  commercialZip: string;
  commercialAttn: string;
  commercialTelephoneNum: string;
  commercialFaxNum: string;
  commercialEmailAddress: string;
  schedulingAddressLine1: string;
  schedulingAddressLine2: string;
  schedulingCountryId: number;
  schedulingCity: string;
  schedulingStateId: number;
  schedulingZip: string;
  schedulingAttn: string;
  schedulingTelephoneNum: string;
  schedulingFaxNum: string;
  schedulingEmailAddress: string;
  noticesAddressLine1: string;
  noticesAddressLine2: string;
  noticesCountryId: number;
  noticesCity: string;
  noticesStateId: number;
  noticesZip: string;
  noticesAttn: string;
  noticesTelephoneNum: string;
  noticesFaxNum: string;
  noticesEmailAddress: string;
  creditAddressLine1: string;
  creditAddressLine2: string;
  creditCountryId: number;
  creditCity: string;
  creditStateId: number;
  creditZip: string;
  creditAttn: string;
  creditTelephoneNum: string;
  creditFaxNum: string;
  creditEmailAddress: string;
  confirmationsAddressLine1: string;
  confirmationsAddressLine2: string;
  confirmationsCountryId: number;
  confirmationsCity: string;
  confirmationsStateId: number;
  confirmationsZip: string;
  confirmationsAttn: string;
  confirmationsTelephoneNum: string;
  confirmationsFaxNum: string;
  confirmationsEmailAddress: string;
  doEmail: boolean;
  doFax: boolean;
  combineEmail: boolean;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  states: util.IdName[];
  countries: util.IdName[];
}

@Injectable({
  providedIn: 'root'
})
export class ContactInfoService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/ContactInfo`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getContactInfo(contractId: number, getInternalSide: boolean, entityId: number, productId: number): Observable<MainContractContactDetail> {
    const url = `${this.baseUrl}/GetContactInfo?contractId=${contractId}&getInternalSide=${getInternalSide}&entityId=${entityId}&productId=${productId}`;
    return this.http.get<MainContractContactDetail>(url);
  }
}
