import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../../_shared/utils/util'

export interface MainContractAccountingDetail {
  isExhibitCChecked: boolean;
  invoiceAddressLine1: string;
  invoiceAddressLine2: string;
  invoiceCountryId: number;
  invoiceCity: string;
  invoiceStateId: number;
  invoiceZip: string;
  invoiceAttn: string;
  invoiceTelephoneNum: string;
  invoiceFaxNum: string;
  invoiceEmailAddress: string;
  doEmail: boolean;
  doFax: boolean;
  wireBank: string;
  wireAbaNum: string;
  wireAccountNum: string;
  wireOtherDetails: string;
  achBank: string;
  achAbaNum: string;
  achAccountNum: string;
  achOtherDetails: string;
  checksAttn: string;
  checksAddressLine1: string;
  checksAddressLine2: string;
  checksCountryId: number;
  checksCity: string;
  checksStateId: number;
  checksZip: string;
  isWireChecked: boolean;
  isChecksChecked: boolean;
  isAchChecked: boolean;
}

export interface PayOptions {
  isWireChecked: boolean;
  isAchChecked: boolean;
  isChecksChecked: boolean;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  states: util.IdName[];
  countries: util.IdName[];
}

@Injectable({
  providedIn: 'root'
})

export class AccountingInfoService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/AccountingInfo`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getAccountingInfo(contractId: number, getInternalSide: boolean, entityId: number, productId: number): Observable<MainContractAccountingDetail> {
    const url = `${this.baseUrl}/GetAccountingInfo?contractId=${contractId}&getInternalSide=${getInternalSide}&entityId=${entityId}&productId=${productId}`;
    return this.http.get<MainContractAccountingDetail>(url);
  }
}
