import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { map, Observable } from 'rxjs';
import dayjs from 'dayjs';

export interface RequiredData {
  hasGasTrackStandardPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class GasTrackService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/GasTrack`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  export(startDate: Date, endDate: Date): Observable<{ fileBlob: Blob, fileName: string }> {
    const startDateStr = dayjs(startDate).format("YYYY-MM-DD");
    const endDateStr = dayjs(endDate).format("YYYY-MM-DD");
    const url = `${this.baseUrl}/Export?startDate=${startDateStr}&endDate=${endDateStr}`;
    return this.http.get(url, { observe: 'response', responseType: 'blob' }).pipe(
      map(result => {
        const fileBlob = result.body;
        const fileName: string = result.body.type === "text/plain" ? "Error.txt" : "GasTrack.txt";
        return { fileBlob, fileName };
      })
    );
  }
}
