// import { Component, ViewEncapsulation, ChangeDetectionStrategy, ChangeDetectorRef, OnInit, inject } from '@angular/core';
import { Component, ViewEncapsulation, ChangeDetectionStrategy, OnInit, inject } from '@angular/core';
import { IdName, filterIdNames } from '../../_shared/utils/util';
import { HttpClient } from '@angular/common/http';
import { BehaviorSubject, of } from 'rxjs';
import { ControlBaseComponent, FilterValue } from '../control-base.component';
import { tap } from 'rxjs/operators';
import { FilterControlService } from '../filter-control.service';
// import { UntypedFormBuilder } from '@angular/forms';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';

@Component({
  selector: 'control-point',
  templateUrl: './control-point.component.html',
  styleUrls: ['./control-point.component.scss'],
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON]
})
export class ControlPointComponent extends ControlBaseComponent implements OnInit {
  items: IdName[];
  virtual = { itemHeight: 28 };

  public http = inject(HttpClient);
  // private ref = inject(ChangeDetectorRef);
  // private fb = inject(UntypedFormBuilder);
  private controlService = inject(FilterControlService);

  constructor() {
    super();
  }

  filterItems$ = new BehaviorSubject<string>(null)

  items$ = this.controlService.points$.pipe(tap((x: IdName[]) => this.items = x))

  filteredItems$ = this.filterItems$.pipe(filterIdNames(of(false), this.items$, null));

  filterItems($event: string) {
    this.filterItems$.next($event);
  }

  getValue(): string {
    return this.mainCtrl.value?.length > 0 ? this.mainCtrl.value.join(',') : null;
  }

  getFilterValue(): FilterValue {
    const value1 = this.getValue();
    const preview = this.getPreview();
    const filterValue: FilterValue = { id: 0, name: this.parameterName, filterId: this.filterId, dataSourceId: this.dataSourceId, preview: preview, value1: value1, value2: null }
    return filterValue;
  }

  getPreview(): string {
    return this.getIdListPreview(this.mainCtrl.value, this.items);
  }

  setFilterValue(param: FilterValue) {
    this.mainCtrl.patchValue(param.value1.split(',').map(x => parseInt(x)));
    this.valueUpdated$.next(null);
    this.ref.detectChanges();
  }

  resetValue() {
    this.form.reset();
    this.mainCtrl.patchValue([]);
    this.valueUpdated$.next(null);
    this.ref.detectChanges();
  }

  valueChanged() {
    this.valueUpdated$.next(null);
  }
}
