import { DealFilter, DisplayInfo } from '../../deal-filter/deal-filter.service';
import { IdNameActive, IdName } from '../../_shared/utils/util';
import { CounterpartyInfo } from './CounterpartyInfo';
import { BookInfo } from './BookInfo';
import { ContactInfo } from './ContactInfo';
import { PipeInfo } from './PipeInfo';
import { PointInfo } from './PointInfo';
import { ContractInfo } from './ContractInfo';
import { ForceMajeureInfo } from './ForceMajeureInfo';
import { TraderInfo } from './TraderInfo';
import { IndexInfo } from './IndexInfo';
import { BrokerAccountInfo } from './BrokerAccountInfo';

export interface RequiredData {
  hasDealModifyPermission: boolean;
  hasDealForAccountingPermission: boolean;
  hasDealSaveSourceDelivery: boolean;
  allColumnDisplayInfos: DisplayInfo[];
  filters: DealFilter[];
  regions: IdNameActive[];
  strategies: IdNameActive[];
  portfolios: IdNameActive[];
  books: BookInfo[];
  counterparties: CounterpartyInfo[];
  internalEntities: IdNameActive[];
  contacts: ContactInfo[];
  traders: TraderInfo[];
  dealStatuses: IdName[];
  dealPurposes: IdName[];
  dealTypes: IdName[];
  priceIndexes: IndexInfo[];
  pipelines: PipeInfo[];
  pipelineSourceDeliveries: PipeInfo[];
  points: PointInfo[];
  pointSourceDeliveries: PointInfo[];
  contracts: ContractInfo[];
  volumeTypes: IdName[];
  fuelCalculationTypes: IdName[];
  forceMajeures: ForceMajeureInfo[];
  dealModifyTimeLag: number;
  transactionTypes: IdName[];
  products: IdName[];
  brokers: IdName[];
  brokerAccounts: BrokerAccountInfo[];
  deliveryMethods: IdName[];
  paidOnTypes: IdName[];
}
