import { ChangeDetectionStrategy, Component, input } from '@angular/core';
import { FAST_KENDO_COMMON } from '../../app.config';

@Component({
  selector: 'fast-header',
  imports: [FAST_KENDO_COMMON],
  template: `
<div id="header" class="flex flex-row mb-3 items-center justify-center min-h-9
  shadow-sm shadow-base-gray-1000
  dark:shadow-sm dark:shadow-base-black-250
  bg-base-white-1000
  dark:bg-alt-gray-1000">
  @if (title()) {
    <div class="flex grow-0 items-center justify-start flex-row mt-1 mb-1 ml-2">
      <h1 class="mr-1 text-xl whitespace-nowrap items-center text-base-black-250 dark:text-base-white-1000">{{title()}}</h1>
    </div>
  }
  <ng-content class="
    bg-base-white-1000
    dark:bg-alt-gray-1000
    text-black
    dark:text-base-white-500"></ng-content>
</div>
  `,
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class FastHeaderComponent {
  title = input<string>(null);
}
