namespace Fast.Shared.Logic.Valuation;

public class ValParams
{
    public ValParams() { }

    public DateOnly AsOfDate { get; set; }

    #region "Deal Filters"
    //the following are used to filter deals but are not used by the valuation process
    public List<DateRange> AccountingMonthRanges { get; set; } = new List<DateRange>();
    public List<DateRange> PositionDateRanges { get; set; } = new List<DateRange>();
    public List<DateRange> TradeDateRanges { get; set; } = new List<DateRange>();
    public List<int> BookIds { get; set; } = new List<int>();
    public List<int> BrokerIds { get; set; } = new List<int>();
    public List<int> BrokerAccountIds { get; set; } = new List<int>();
    public int? BuySell { get; set; } = null;
    public List<int> ProductIds { get; set; } = new List<int>();
    public List<int> CounterpartyIds { get; set; } = new List<int>();
    public List<int> DealPurposeIds { get; set; } = new List<int>();
    public List<int> DealStatusIds { get; set; } = new List<int>();
    public List<int> DealTypeIds { get; set; } = new List<int>();
    public int? Hypothetical { get; set; } = 0;  //0 = real deals, 1 = hypothetical deals, null = all deals
    public List<int> InternalEntityIds { get; set; } = new List<int>();
    public List<int> PipelineIds { get; set; } = new List<int>();
    public List<int> PointIds { get; set; } = new List<int>();
    public List<int> PortfolioIds { get; set; } = new List<int>();
    public List<int> PriceIndexIds { get; set; } = new List<int>();
    public List<int> RegionIds { get; set; } = new List<int>();
    public List<int> StrategyIds { get; set; } = new List<int>();
    public List<int> TraderIds { get; set; } = new List<int>();
    public List<int> TransactionTypeIds { get; set; } = new List<int>();
    public List<int> UtilityIds { get; set; } = new List<int>();
    public bool IncludeSosDeals { get; set; } = false;
    public bool IncludeBasisInContractPrice { get; set; } = true;
    public bool? IsPooledFutureDeal { get; set; } = null;
    public bool? IsWaspNumNull { get; set; } = null;
    #endregion

    #region "Valuation Settings"
    //the following are used by the valuation process but do not filter deals
    public int CurrencyId { get; set; } = 1;
    public int? UnitOfMeasureId { get; set; } = 2;
    public string TicketNum { get; set; } = "";
    public int? BasisBuySell { get; set; } = null;
    public int? ExecutionMarginBuySell { get; set; } = null;
    public int? MarginBuySell { get; set; } = null;
    public int? NymexExecutionBuySell { get; set; } = null;
    #endregion
}
