using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("w9_form_doc")]
public partial class W9FormDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("w9_form_id")]
    public int W9FormId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("W9FormId")]
    [InverseProperty("W9FormDocs")]
    public virtual W9Form W9Form { get; set; } = null!;
}
