using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Keyless]
public partial class VwValDealVolume
{
    [Column("deal_id")]
    public int? DealId { get; set; }

    [Column("ticket_num", TypeName = "citext")]
    public string? TicketNum { get; set; }

    [Column("physical_volume")]
    public double? PhysicalVolume { get; set; }

    [Column("financial_volume")]
    public double? FinancialVolume { get; set; }

    [Column("actual_volume")]
    public double? ActualVolume { get; set; }

    [Column("start_date")]
    public DateOnly? StartDate { get; set; }

    [Column("end_date")]
    public DateOnly? EndDate { get; set; }

    [Column("trading_date")]
    public DateOnly? TradingDate { get; set; }

    [Column("accounting_month")]
    public DateOnly? AccountingMonth { get; set; }

    [Column("buy_button")]
    public int? BuyButton { get; set; }

    [Column("hypothetical_id")]
    public int? HypotheticalId { get; set; }

    [Column("transaction_type_id")]
    public int? TransactionTypeId { get; set; }

    [Column("is_pooled_future_deal")]
    public int? IsPooledFutureDeal { get; set; }

    [Column("price_index_id")]
    public int? PriceIndexId { get; set; }

    [Column("price_index_id2")]
    public int? PriceIndexId2 { get; set; }

    [Column("date_key")]
    public DateOnly? DateKey { get; set; }

    [Column("book_id")]
    public int? BookId { get; set; }

    [Column("broker_id")]
    public int? BrokerId { get; set; }

    [Column("broker_account_id")]
    public int? BrokerAccountId { get; set; }

    [Column("product_id")]
    public int? ProductId { get; set; }

    [Column("product_category_id")]
    public int? ProductCategoryId { get; set; }

    [Column("counterparty_id")]
    public int? CounterpartyId { get; set; }

    [Column("deal_purpose_id")]
    public int? DealPurposeId { get; set; }

    [Column("deal_status_id")]
    public int? DealStatusId { get; set; }

    [Column("internal_entity_id")]
    public int? InternalEntityId { get; set; }

    [Column("physical_deal_type_id")]
    public int? PhysicalDealTypeId { get; set; }

    [Column("pipeline_id")]
    public int? PipelineId { get; set; }

    [Column("pipeline_source_delivery_id")]
    public int? PipelineSourceDeliveryId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("portfolio_id")]
    public int? PortfolioId { get; set; }

    [Column("region_id")]
    public int? RegionId { get; set; }

    [Column("strategy_id")]
    public int? StrategyId { get; set; }

    [Column("trader_id")]
    public int? TraderId { get; set; }

    [Column("wasp_num", TypeName = "citext")]
    public string? WaspNum { get; set; }
}
