using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("unit_of_measure")]
public partial class UnitOfMeasure
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("symbol", TypeName = "citext")]
    public string Symbol { get; set; } = null!;

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [InverseProperty("UnitOfMeasure")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();

    [InverseProperty("DefaultUnitOfMeasure")]
    public virtual ICollection<MeterType> MeterTypes { get; set; } = new List<MeterType>();

    [InverseProperty("UnitOfMeasure")]
    public virtual ICollection<Product> Products { get; set; } = new List<Product>();

    [InverseProperty("FromUnitOfMeasure")]
    public virtual ICollection<UnitOfMeasureConversion> UnitOfMeasureConversions { get; set; } = new List<UnitOfMeasureConversion>();

    [InverseProperty("UnitOfMeasure")]
    public virtual ICollection<UnitPriceCombination> UnitPriceCombinations { get; set; } = new List<UnitPriceCombination>();
}
