using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("sos_gas_pipe_setting")]
[Index("UserId", "PipeId", Name = "uk_sos_gas_pipe_setting", IsUnique = true)]
public partial class SosGasPipeSetting
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("pipe_id")]
    public int? PipeId { get; set; }

    [Column("font_size")]
    public int FontSize { get; set; }

    [Column("main_frozen_column_count")]
    public int MainFrozenColumnCount { get; set; }

    [Column("main_columns", TypeName = "citext")]
    public string MainColumns { get; set; } = null!;

    [Column("transfer_frozen_column_count")]
    public int TransferFrozenColumnCount { get; set; }

    [Column("transfer_columns", TypeName = "citext")]
    public string TransferColumns { get; set; } = null!;

    [Column("sorts", TypeName = "citext")]
    public string? Sorts { get; set; }

    [ForeignKey("PipeId")]
    [InverseProperty("SosGasPipeSettings")]
    public virtual Pipeline? Pipe { get; set; }

    [ForeignKey("UserId")]
    [InverseProperty("SosGasPipeSettings")]
    public virtual AppUser User { get; set; } = null!;
}
