using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("sales_tax_detail")]
[Index("SalesTaxId", "MinAmount", "TaxTypeId", "EffectiveDate", Name = "uk_sales_tax_detail", IsUnique = true)]
public partial class SalesTaxDetail
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("sales_tax_id")]
    public int SalesTaxId { get; set; }

    [Column("min_amount")]
    public decimal? MinAmount { get; set; }

    [Column("max_amount")]
    public decimal? MaxAmount { get; set; }

    [Column("rate_state")]
    public decimal? RateState { get; set; }

    [Column("rate_local")]
    public decimal? RateLocal { get; set; }

    [Column("rate_special")]
    public decimal? RateSpecial { get; set; }

    [Column("rate_education")]
    public decimal? RateEducation { get; set; }

    [Column("rate_transport")]
    public decimal? RateTransport { get; set; }

    [Column("rate_marta")]
    public decimal? RateMarta { get; set; }

    [Column("rate_homestead")]
    public decimal? RateHomestead { get; set; }

    [Column("rate_other")]
    public decimal? RateOther { get; set; }

    [Column("tax_type_id")]
    public int TaxTypeId { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [Column("expiration_date")]
    public DateOnly? ExpirationDate { get; set; }

    [ForeignKey("SalesTaxId")]
    [InverseProperty("SalesTaxDetails")]
    public virtual SalesTax SalesTax { get; set; } = null!;

    [ForeignKey("TaxTypeId")]
    [InverseProperty("SalesTaxDetails")]
    public virtual SalesTaxType TaxType { get; set; } = null!;
}
