using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("quality_bank_adjustment")]
[Index("Month", "ContractId", "AsOfDate", Name = "idx_27091_uk_quality_bank_adjustment", IsUnique = true)]
public partial class QualityBankAdjustment
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("month")]
    public DateOnly Month { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("as_of_date")]
    public DateOnly AsOfDate { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("QualityBankAdjustments")]
    public virtual Contract Contract { get; set; } = null!;

    [InverseProperty("QualityBankAdjustment")]
    public virtual ICollection<QualityBankAdjustmentDetail> QualityBankAdjustmentDetails { get; set; } = new List<QualityBankAdjustmentDetail>();
}
