using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[PrimaryKey("PublishedIndexId", "InternalIndexId")]
[Table("published_to_internal_index")]
[Index("PublishedIndexId", Name = "uk_published_to_internal_index_published_internal_mapping", IsUnique = true)]
public partial class PublishedToInternalIndex
{
    [Key]
    [Column("published_index_id")]
    public int PublishedIndexId { get; set; }

    [Key]
    [Column("internal_index_id")]
    public int InternalIndexId { get; set; }

    [ForeignKey("InternalIndexId")]
    [InverseProperty("PublishedToInternalIndexInternalIndices")]
    public virtual MarketIndex InternalIndex { get; set; } = null!;

    [ForeignKey("PublishedIndexId")]
    [InverseProperty("PublishedToInternalIndexPublishedIndex")]
    public virtual MarketIndex PublishedIndex { get; set; } = null!;
}
