using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("plant_statement_descriptor")]
public partial class PlantStatementDescriptor
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("StatementDescriptor")]
    public virtual ICollection<PlantStatement> PlantStatements { get; set; } = new List<PlantStatement>();
}
