using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("plant_statement_combined_meter")]
[Index("PlantStatementId", "MeterId", Name = "uk_plant_statement_combined_meter", IsUnique = true)]
public partial class PlantStatementCombinedMeter
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("plant_statement_id")]
    public int PlantStatementId { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [Column("wellhead_volume_mmbtu")]
    public int WellheadVolumeMmbtu { get; set; }

    [Column("wellhead_volume_mcf")]
    public int? WellheadVolumeMcf { get; set; }

    [Column("pipeline_volume")]
    public int? PipelineVolume { get; set; }

    [Column("wellhead_ptr_price")]
    public decimal? WellheadPtrPrice { get; set; }

    [Column("liquids_take_percent")]
    public decimal? LiquidsTakePercent { get; set; }

    [Column("in_kind_pvr_mcf")]
    public int? InKindPvrMcf { get; set; }

    [Column("in_kind_ptr_mmbtu")]
    public int? InKindPtrMmbtu { get; set; }

    [ForeignKey("MeterId")]
    [InverseProperty("PlantStatementCombinedMeters")]
    public virtual Meter Meter { get; set; } = null!;

    [ForeignKey("PlantStatementId")]
    [InverseProperty("PlantStatementCombinedMeters")]
    public virtual PlantStatement PlantStatement { get; set; } = null!;
}
