using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("pipeline_tariff")]
[Index("RateScheduleId", "TariffTypeId", "EffectiveDate", Name = "ix_pipeline_tariff")]
public partial class PipelineTariff
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("rate_schedule_id")]
    public int RateScheduleId { get; set; }

    [Column("tariff_type_id")]
    public int TariffTypeId { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [Column("tariff_rate")]
    public double? TariffRate { get; set; }

    [Column("comments", TypeName = "citext")]
    public string? Comments { get; set; }

    [Column("application_rule_id")]
    public int ApplicationRuleId { get; set; }

    [ForeignKey("ApplicationRuleId")]
    [InverseProperty("PipelineTariffs")]
    public virtual PipeRateApplicationRule ApplicationRule { get; set; } = null!;

    [InverseProperty("PipelineTariff")]
    public virtual ICollection<PipeRateDoc> PipeRateDocs { get; set; } = new List<PipeRateDoc>();

    [InverseProperty("Tariff")]
    public virtual ICollection<PipelineTariffDatum> PipelineTariffData { get; set; } = new List<PipelineTariffDatum>();

    [ForeignKey("RateScheduleId")]
    [InverseProperty("PipelineTariffs")]
    public virtual PipelineRateSchedule RateSchedule { get; set; } = null!;

    [ForeignKey("TariffTypeId")]
    [InverseProperty("PipelineTariffs")]
    public virtual PipelineTariffType TariffType { get; set; } = null!;
}
