using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("pipeline_rate_discounted_from_to")]
[Index("DiscountedRateId", "ZoneId", "MeterId", "IsFrom", Name = "uk_pipeline_rate_discounted_from_to", IsUnique = true)]
public partial class PipelineRateDiscountedFromTo
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("discounted_rate_id")]
    public int DiscountedRateId { get; set; }

    [Column("zone_id")]
    public int ZoneId { get; set; }

    [Column("meter_id")]
    public int? MeterId { get; set; }

    [Column("is_from")]
    public bool IsFrom { get; set; }

    [ForeignKey("DiscountedRateId")]
    [InverseProperty("PipelineRateDiscountedFromTos")]
    public virtual PipelineRateDiscounted DiscountedRate { get; set; } = null!;

    [ForeignKey("MeterId")]
    [InverseProperty("PipelineRateDiscountedFromTos")]
    public virtual Meter? Meter { get; set; }

    [ForeignKey("ZoneId")]
    [InverseProperty("PipelineRateDiscountedFromTos")]
    public virtual Zone Zone { get; set; } = null!;
}
