using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("pipeline")]
public partial class Pipeline
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("pipeline_description", TypeName = "citext")]
    public string? PipelineDescription { get; set; }

    [Column("pipe_short", TypeName = "citext")]
    public string? PipeShort { get; set; }

    [Column("pipe_code", TypeName = "citext")]
    public string? PipeCode { get; set; }

    [Column("default_ptr_pipeline_contract_id")]
    public int? DefaultPtrPipelineContractId { get; set; }

    [Column("pipeline_type_id")]
    public int PipelineTypeId { get; set; }

    [Column("product_ids", TypeName = "citext")]
    public string? ProductIds { get; set; }

    [InverseProperty("PipelineSourceDelivery")]
    public virtual ICollection<Deal> DealPipelineSourceDeliveries { get; set; } = new List<Deal>();

    [InverseProperty("Pipeline")]
    public virtual ICollection<Deal> DealPipelines { get; set; } = new List<Deal>();

    [ForeignKey("DefaultPtrPipelineContractId")]
    [InverseProperty("Pipelines")]
    public virtual PipelineContract? DefaultPtrPipelineContract { get; set; }

    [InverseProperty("Pipeline")]
    public virtual ICollection<PipelineContractDefault> PipelineContractDefaults { get; set; } = new List<PipelineContractDefault>();

    [InverseProperty("Pipeline")]
    public virtual ICollection<PipelineContract> PipelineContracts { get; set; } = new List<PipelineContract>();

    [InverseProperty("Pipeline")]
    public virtual ICollection<PipelineRateSchedule> PipelineRateSchedules { get; set; } = new List<PipelineRateSchedule>();

    [ForeignKey("PipelineTypeId")]
    [InverseProperty("Pipelines")]
    public virtual PipelineType PipelineType { get; set; } = null!;

    [InverseProperty("Pipeline")]
    public virtual ICollection<Point> Points { get; set; } = new List<Point>();

    [InverseProperty("Pipe")]
    public virtual ICollection<SosCrudePipeSetting> SosCrudePipeSettings { get; set; } = new List<SosCrudePipeSetting>();

    [InverseProperty("AutoSelectPipeline")]
    public virtual ICollection<SosCrudeSetting> SosCrudeSettings { get; set; } = new List<SosCrudeSetting>();

    [InverseProperty("Pipe")]
    public virtual ICollection<SosGasPipeSetting> SosGasPipeSettings { get; set; } = new List<SosGasPipeSetting>();

    [InverseProperty("Pipe")]
    public virtual ICollection<SosSnapshot> SosSnapshots { get; set; } = new List<SosSnapshot>();

    [InverseProperty("Pipeline")]
    public virtual ICollection<Zone> Zones { get; set; } = new List<Zone>();
}
