using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

public partial class OpenIddictApplication
{
    [Key]
    [Column(TypeName = "citext")]
    public string Id { get; set; } = null!;

    [Column(TypeName = "citext")]
    public string? ApplicationType { get; set; }

    [Column(TypeName = "citext")]
    public string? ClientId { get; set; }

    [Column(TypeName = "citext")]
    public string? ClientSecret { get; set; }

    [Column(TypeName = "citext")]
    public string? ClientType { get; set; }

    [Column(TypeName = "citext")]
    public string? ConcurrencyToken { get; set; }

    [Column(TypeName = "citext")]
    public string? ConsentType { get; set; }

    [Column(TypeName = "citext")]
    public string? DisplayName { get; set; }

    [Column(TypeName = "citext")]
    public string? DisplayNames { get; set; }

    [Column(TypeName = "citext")]
    public string? JsonWebKeySet { get; set; }

    [Column(TypeName = "citext")]
    public string? Permissions { get; set; }

    [Column(TypeName = "citext")]
    public string? PostLogoutRedirectUris { get; set; }

    [Column(TypeName = "citext")]
    public string? Properties { get; set; }

    [Column(TypeName = "citext")]
    public string? RedirectUris { get; set; }

    [Column(TypeName = "citext")]
    public string? Requirements { get; set; }

    [Column(TypeName = "citext")]
    public string? Settings { get; set; }

    [InverseProperty("Application")]
    public virtual ICollection<OpenIddictAuthorization> OpenIddictAuthorizations { get; set; } = new List<OpenIddictAuthorization>();

    [InverseProperty("Application")]
    public virtual ICollection<OpenIddictToken> OpenIddictTokens { get; set; } = new List<OpenIddictToken>();
}
