using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("meter")]
[Index("Name", "InactiveDate", Name = "uk_meter", IsUnique = true)]
public partial class Meter
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("inactive_date")]
    public DateOnly? InactiveDate { get; set; }

    [Column("producer_ids", TypeName = "citext")]
    public string? ProducerIds { get; set; }

    [Column("lease_id")]
    public int? LeaseId { get; set; }

    [Column("location_id")]
    public int? LocationId { get; set; }

    [Column("latitude")]
    public decimal? Latitude { get; set; }

    [Column("longitude")]
    public decimal? Longitude { get; set; }

    [Column("old_panton_id")]
    public int? OldPantonId { get; set; }

    [Column("state_id")]
    public int? StateId { get; set; }

    [Column("county_id")]
    public int? CountyId { get; set; }

    [InverseProperty("TneMeter")]
    public virtual ICollection<CrudeActual> CrudeActuals { get; set; } = new List<CrudeActual>();

    [InverseProperty("Meter")]
    public virtual ICollection<CrudeMarket> CrudeMarkets { get; set; } = new List<CrudeMarket>();

    [InverseProperty("SourceMeter")]
    public virtual ICollection<CrudePath> CrudePaths { get; set; } = new List<CrudePath>();

    [InverseProperty("Meter")]
    public virtual ICollection<CrudeSupply> CrudeSupplyMeters { get; set; } = new List<CrudeSupply>();

    [InverseProperty("PtrDeliveryMeter")]
    public virtual ICollection<CrudeSupply> CrudeSupplyPtrDeliveryMeters { get; set; } = new List<CrudeSupply>();

    [InverseProperty("TneMeter")]
    public virtual ICollection<GasActual> GasActuals { get; set; } = new List<GasActual>();

    [InverseProperty("Meter")]
    public virtual ICollection<GasMarket> GasMarkets { get; set; } = new List<GasMarket>();

    [InverseProperty("SourceMeter")]
    public virtual ICollection<GasPath> GasPaths { get; set; } = new List<GasPath>();

    [InverseProperty("Meter")]
    public virtual ICollection<GasSupply> GasSupplyMeters { get; set; } = new List<GasSupply>();

    [InverseProperty("PtrDeliveryMeter")]
    public virtual ICollection<GasSupply> GasSupplyPtrDeliveryMeters { get; set; } = new List<GasSupply>();

    [InverseProperty("DeliveryMeter")]
    public virtual ICollection<InvoiceCrudeLine> InvoiceCrudeLineDeliveryMeters { get; set; } = new List<InvoiceCrudeLine>();

    [InverseProperty("ReceiptMeter")]
    public virtual ICollection<InvoiceCrudeLine> InvoiceCrudeLineReceiptMeters { get; set; } = new List<InvoiceCrudeLine>();

    [InverseProperty("Meter")]
    public virtual ICollection<InvoiceGasLine> InvoiceGasLines { get; set; } = new List<InvoiceGasLine>();

    [ForeignKey("LeaseId")]
    [InverseProperty("Meters")]
    public virtual Lease? Lease { get; set; }

    [ForeignKey("LocationId")]
    [InverseProperty("Meters")]
    public virtual Location? Location { get; set; }

    [InverseProperty("Meter")]
    public virtual ICollection<MeterProduct> MeterProducts { get; set; } = new List<MeterProduct>();

    [InverseProperty("Meter")]
    public virtual ICollection<MeterPtr> MeterPtrs { get; set; } = new List<MeterPtr>();

    [InverseProperty("Meter")]
    public virtual ICollection<PipeContractDeliveryMeter> PipeContractDeliveryMeters { get; set; } = new List<PipeContractDeliveryMeter>();

    [InverseProperty("Meter")]
    public virtual ICollection<PipeContractReceiptMeter> PipeContractReceiptMeters { get; set; } = new List<PipeContractReceiptMeter>();

    [InverseProperty("Meter")]
    public virtual ICollection<PipelineRateDiscountedFromTo> PipelineRateDiscountedFromTos { get; set; } = new List<PipelineRateDiscountedFromTo>();

    [InverseProperty("Meter")]
    public virtual ICollection<PlantStatementCombinedMeter> PlantStatementCombinedMeters { get; set; } = new List<PlantStatementCombinedMeter>();

    [InverseProperty("Meter")]
    public virtual ICollection<PlantStatement> PlantStatements { get; set; } = new List<PlantStatement>();

    [InverseProperty("ReceiptMeter")]
    public virtual ICollection<SosHiddenDeal> SosHiddenDeals { get; set; } = new List<SosHiddenDeal>();

    [ForeignKey("StateId")]
    [InverseProperty("Meters")]
    public virtual Territory? State { get; set; }

    [InverseProperty("Meter1")]
    public virtual ICollection<TransferMeter> TransferMeterMeter1s { get; set; } = new List<TransferMeter>();

    [InverseProperty("Meter2")]
    public virtual ICollection<TransferMeter> TransferMeterMeter2s { get; set; } = new List<TransferMeter>();
}
