using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("invoice_gas_line")]
[Index("DealId", Name = "ix_invoice_gas_line_deal_id")]
[Index("InvoiceId", Name = "ix_invoice_gas_line_invoice_id")]
[Index("InvoiceId", "LineNum", Name = "ix_invoice_gas_line_invoice_id_line_num")]
public partial class InvoiceGasLine
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("invoice_id")]
    public int InvoiceId { get; set; }

    [Column("line_num")]
    public int LineNum { get; set; }

    [Column("deal_id")]
    public int? DealId { get; set; }

    [Column("flow_days", TypeName = "citext")]
    public string? FlowDays { get; set; }

    [Column("quantity")]
    public decimal? Quantity { get; set; }

    [Column("price")]
    public decimal? Price { get; set; }

    [Column("approved_by")]
    public int? ApprovedBy { get; set; }

    [Column("approved_time")]
    public DateTime? ApprovedTime { get; set; }

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [Column("amount")]
    public decimal Amount { get; set; }

    [Column("meter_id")]
    public int? MeterId { get; set; }

    [Column("adder")]
    public decimal? Adder { get; set; }

    [Column("pipeline_custom_text", TypeName = "citext")]
    public string? PipelineCustomText { get; set; }

    [Column("meter_custom_text", TypeName = "citext")]
    public string? MeterCustomText { get; set; }

    [ForeignKey("ApprovedBy")]
    [InverseProperty("InvoiceGasLines")]
    public virtual AppUser? ApprovedByNavigation { get; set; }

    [ForeignKey("DealId")]
    [InverseProperty("InvoiceGasLines")]
    public virtual Deal? Deal { get; set; }

    [ForeignKey("InvoiceId")]
    [InverseProperty("InvoiceGasLines")]
    public virtual InvoiceGa Invoice { get; set; } = null!;

    [ForeignKey("MeterId")]
    [InverseProperty("InvoiceGasLines")]
    public virtual Meter? Meter { get; set; }
}
